/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 **********************************************************************
 * HISTORY
 * $Log:	tty_tb.c,v $
 * Revision 2.5  88/10/27  10:41:33  rpd
 * 	Added new ioctls TBIOGETC and TBIOSETC, used to get/set
 * 	the compatibility mode (which determines whether tablets
 * 	are numbered with Acis or BSD numbers).
 * 	[88/10/26  14:28:10  rpd]
 * 
 * Revision 2.4  88/10/01  21:50:01  rpd
 * 	Changed includes to the new style.
 * 	Eliminated romp conditionals.
 * 	Changed sync_value to tbc_sync_value.
 * 	Fixed precedence bug in tbinput.
 * 	Added ROMP_TBCOMPAT support.
 * 	[88/09/28  17:03:44  rpd]
 * 
 * Revision 2.3  88/08/24  01:50:57  mwyoung
 * 	Corrected include file references.
 * 	[88/08/22            mwyoung]
 * 
 *
 * 15-Jul-87  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	struct tbpos -> struct tbmspos.
 *
 *  9-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	TB -> ROMP_TB.
 *
 *  2-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Relocated this file to caio/tty_tb.c since it is fairly RT
 *	specific.
 *
 *  1-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Support MACH.
 *
 * 22-Jan-87  Richard Sanzi (sanzi) at Carnegie-Mellon University
 *	Merged in 4.2 ACIS driver.  The changes include:
 *		1) Input Emulator support (primarily for X support on the RT).
 *		2) New sync_value field in ../h/tablet.h (struct tb),
 *		   which supports a more general sync value from
 *		   the mouse/tablet.
 *
 */ 
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)tty_tb.c	7.1 (Berkeley) 6/5/86
 */
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */


#include <romp_tb.h>
#if NROMP_TB > 0
#include <cmucs.h>
#include <mach.h>
#include <romp_tbcompat.h>

/*
 * Line discipline for RS232 tablets;
 * supplies binary coordinate data.
 */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/ioctl.h>
#include <sys/tty.h>
#include <sys/proc.h>
#include <sys/inode.h>
#include <sys/conf.h>
#include <sys/file.h>
#include <sys/buf.h>
#include <sys/uio.h>
#include <sys/tablet.h>	
#include <cacons/screen_conf.h>

/*
 * Tablet configuration table.
 */
struct	tbconf {
	short	tbc_recsize;	/* input record size in bytes */
	short	tbc_uiosize;	/* size of data record returned user */
	int	tbc_sync;	/* mask for finding sync byte/bit */
#if	CMUCS	
	int	tbc_sync_value;	/* Actual sync value */
#endif	CMUCS	
	int	(*tbc_decode)();/* decoding routine */
	char	*tbc_run;	/* enter run mode sequence */
	char	*tbc_point;	/* enter point mode sequence */
	char	*tbc_stop;	/* stop sequence */
	char	*tbc_start;	/* start/restart sequence */
	int	tbc_flags;
#define	TBF_POL	0x1	/* polhemus hack */
};


static	int tbdecode(), gtcodecode(), poldecode();
static	int tblresdecode(), tbhresdecode();
static 	int calcomp_disc_decode(),pcmsdisc_decode();
static 	int pmsdisc3_decode(),pmsdisc2_decode();

#if	CMUCS

struct	tbconf tbconf_acis[TBTYPE] = {
{ 5, sizeof (struct tbmspos), 0200, 0200, tbdecode, "6", "4" },
{ 8, sizeof (struct gtcopos), 0200, 0200, gtcodecode },
{ 5, sizeof (struct tbmspos), 0100, 0100, calcomp_disc_decode, 0, 0, 0, 0,TBBINDATA },
{ 5, sizeof (struct tbmspos), 0360, 0x80, pcmsdisc_decode, 0, 0, 0, 0,TBBINDATA },
{ 4, sizeof (struct tbmspos), 0377, 0x0B, pmsdisc3_decode, 0, 0, 0, 0,TBBINDATA },
{ 4, sizeof (struct tbmspos), 0377, 0x0B, pmsdisc2_decode, 0, 0, 0, 0,TBBINDATA },
};

struct	tbconf tbconf_bsd[TBTYPE] = {
{ 0 },
{ 5, sizeof (struct tbmspos), 0200, 0200, tbdecode, "6", "4" },
{ 5, sizeof (struct tbmspos), 0200, 0200, tbdecode, "\1CN", "\1RT", "\2", "\4" },
{ 8, sizeof (struct gtcopos), 0200, 0200, gtcodecode },
{17, sizeof (struct polpos), 0200, 0200, poldecode, 0, 0, "\21", "\5\22\2\23",
 TBF_POL },
{ 5, sizeof (struct tbmspos), 0100, 0100, tblresdecode, "\1CN", "\1PT", "\2", "\4"},
{ 6, sizeof (struct tbmspos), 0200, 0100, tbhresdecode, "\1CN", "\1PT", "\2", "\4"},
{ 5, sizeof (struct tbmspos), 0100, 0100, calcomp_disc_decode, 0, 0, 0, 0,TBBINDATA },
{ 5, sizeof (struct tbmspos), 0360, 0x80, pcmsdisc_decode, 0, 0, 0, 0,TBBINDATA },
{ 4, sizeof (struct tbmspos), 0377, 0x0B, pmsdisc3_decode, 0, 0, 0, 0,TBBINDATA },
{ 4, sizeof (struct tbmspos), 0377, 0x0B, pmsdisc2_decode, 0, 0, 0, 0,TBBINDATA },
};

#if	ROMP_TBCOMPAT
struct	tbconf *tbconf = tbconf_acis;
#else	ROMP_TBCOMPAT
struct	tbconf *tbconf = tbconf_bsd;
#endif	ROMP_TBCOMPAT

#else	CMUCS

struct	tbconf tbconf[TBTYPE] = {
{ 0 },
{ 5, sizeof (struct tbmspos), 0200, tbdecode, "6", "4" },
{ 5, sizeof (struct tbmspos), 0200, tbdecode, "\1CN", "\1RT", "\2", "\4" },
{ 8, sizeof (struct gtcopos), 0200, gtcodecode },
{17, sizeof (struct polpos), 0200, poldecode, 0, 0, "\21", "\5\22\2\23",
 TBF_POL },
{ 5, sizeof (struct tbmspos), 0100, tblresdecode, "\1CN", "\1PT", "\2", "\4"},
{ 6, sizeof (struct tbmspos), 0200, tbhresdecode, "\1CN", "\1PT", "\2", "\4"},
};

#endif	CMUCS

/* Generic Button definitions */
#define RIGHT_BUT	0x04
#define MIDDLE_BUT	0x02
#define LEFT_BUT	0x01
#define NO_BUT		0x00

/* Emulator support */
extern SCREEN_INFO cons_info[];
extern int cons_if;
#define ms_info (cons_info[cons_if])

int tb_debug = 0;

/*
 * Open as tablet discipline; called on discipline change.
 */
/*ARGSUSED*/
tbopen(dev, tp)
	dev_t dev;
	register struct tty *tp;
{
	register struct tb *tbp;

	if (tp->t_line == TABLDISC)
		return (ENODEV);
	ttywflush(tp);
	for (tbp = tb; tbp < &tb[NTBS]; tbp++)
		if (tbp->tbflags == 0)
			break;
	if (tbp >= &tb[NTBS])
		return (EBUSY);
#if	CMUCS
	if (tbconf == tbconf_acis)
		tbp->tbflags = HITACHI_DISC|TBPOINT;
	else
		tbp->tbflags = TBTIGER|TBPOINT;
#else	CMUCS
	tbp->tbflags = TBTIGER|TBPOINT;		/* default */
#endif	CMUCS
	tp->t_cp = tbp->cbuf;
	tp->t_inbuf = 0;
	tbp->lastindex = 0;
	bzero((caddr_t)tbp->rets, sizeof (tbp->rets[0]) * TBQUEUESIZE);
	tp->T_LINEP = (caddr_t)tbp;
	tp->t_flags |= LITOUT;
	return (0);
}

/*
 * Line discipline change or last device close.
 */
tbclose(tp)
	register struct tty *tp;
{
	register int s;
	int modebits = TBPOINT|TBSTOP;

	tbioctl(tp, BIOSMODE, &modebits, 0);
	s = spl5();
	((struct tb *)tp->T_LINEP)->tbflags = 0;
	tp->t_cp = 0;
	tp->t_inbuf = 0;
	tp->t_rawq.c_cc = 0;		/* clear queues -- paranoid */
	tp->t_canq.c_cc = 0;
	tp->t_line = 0;			/* paranoid: avoid races */
	splx(s);
}

/*
 * Read from a tablet line.
 * Characters have been buffered in a buffer and decoded.
 */
tbread(tp, uio)
	register struct tty *tp;
	struct uio *uio;
{
	register struct tb *tbp = (struct tb *)tp->T_LINEP;
	register struct tbconf *tc = &tbconf[tbp->tbflags & TBTYPE];
	register struct tbmspos *tbpos = (struct tbmspos *) &(tbp->rets[tbp->lastindex]);
	int ret;

	if ((tp->t_state&TS_CARR_ON) == 0)
		return (EIO);
	{
	    	int s;
		s = spl5();
		while (tbp->curindex == tbp->lastindex)
			sleep((caddr_t)tbpos, TTIPRI);
		tbp->lastindex = (tbp->lastindex + 1) % TBQUEUESIZE;
		splx(s);
		ret = uiomove(tbpos, tc->tbc_uiosize, UIO_READ, uio);
	}
	return (ret);
}

/*
 * Low level character input routine.
 * Stuff the character in the buffer, and decode
 * if all the chars are there.
 *
 * This routine could be expanded in-line in the receiver
 * interrupt routine to make it run as fast as possible.
 */
tbinput(c, tp)
	register int c;
	register struct tty *tp;
{
	register SCREEN_INFO *si = &ms_info;
	register struct tb *tbp = (struct tb *)tp->T_LINEP;
	register struct tbconf *tc = &tbconf[tbp->tbflags & TBTYPE];

	if (tc->tbc_recsize == 0 || tc->tbc_decode == 0)	/* paranoid? */
		return;
	/*
	 * Locate sync bit/byte or reset input buffer.
	 */
#if	CMUCS
	if (((c&tc->tbc_sync) == tc->tbc_sync_value) || tp->t_inbuf == tc->tbc_recsize) {
#else	CMUCS
	if (c&tc->tbc_sync || tp->t_inbuf == tc->tbc_recsize) {
#endif	CMUCS
		tp->t_cp = tbp->cbuf;
		tp->t_inbuf = 0;
	}
	if (tc->tbc_flags & TBBINDATA) { 
	    *tp->t_cp++ = c;
	} else {
	    *tp->t_cp++ = c&0177;
	}
	/*
	 * Call decode routine only if a full record has been collected.
	 */
	if (++tp->t_inbuf == tc->tbc_recsize)
		if ((*tc->tbc_decode)(tbp->cbuf, &tbp->rets[tbp->curindex],tp, si)) {
			record_pos (tbp, tp, si);
			tp->t_cp = tbp->cbuf;
			tp->t_inbuf = 0;
		}
}

/*
 * Decode GTCO 8 byte format (high res, tilt, and pressure).
 */
static
gtcodecode(cp, tbpos)
	register char *cp;
	register struct gtcopos *tbpos;
{

	tbpos->pressure = *cp >> 2;
	tbpos->status = (tbpos->pressure > 16) | TBINPROX; /* half way down */
	tbpos->xpos = (*cp++ & 03) << 14;
	tbpos->xpos |= *cp++ << 7;
	tbpos->xpos |= *cp++;
	tbpos->ypos = (*cp++ & 03) << 14;
	tbpos->ypos |= *cp++ << 7;
	tbpos->ypos |= *cp++;
	tbpos->xtilt = *cp++;
	tbpos->ytilt = *cp++;
	tbpos->scount++;
}

/*
 * Decode old Hitachi 5 byte format (low res).
 */
static
tbdecode(cp, tbpos)
	register char *cp;
	register struct tbmspos *tbpos;
{
	register char byte;

	byte = *cp++;
	tbpos->status = (byte&0100) ? TBINPROX : 0;
	byte &= ~0100;
	if (byte > 036)
		tbpos->status |= 1 << ((byte-040)/2);
	tbpos->xpos = *cp++ << 7;
	tbpos->xpos |= *cp++;
	if (tbpos->xpos < 256)			/* tablet wraps around at 256 */
		tbpos->status &= ~TBINPROX;	/* make it out of proximity */
	tbpos->ypos = *cp++ << 7;
	tbpos->ypos |= *cp++;
	tbpos->scount++;
}

/*
 * Decode new Hitach 5-byte format (low res).
 */
static
tblresdecode(cp, tbpos)
	register char *cp;
	register struct tbmspos *tbpos;
{

	*cp &= ~0100;		/* mask sync bit */
	tbpos->status = (*cp++ >> 2) | TBINPROX;
	tbpos->xpos = *cp++;
	tbpos->xpos |= *cp++ << 6;
	tbpos->ypos = *cp++;
	tbpos->ypos |= *cp++ << 6;
	tbpos->scount++;
}

/*
 * Decode new Hitach 6-byte format (high res).
 */
static
tbhresdecode(cp, tbpos)
	register char *cp;
	register struct tbmspos *tbpos;
{
	char byte;

	byte = *cp++;
	tbpos->xpos = (byte & 03) << 14;
	tbpos->xpos |= *cp++ << 7;
	tbpos->xpos |= *cp++;
	tbpos->ypos = *cp++ << 14;
	tbpos->ypos |= *cp++ << 7;
	tbpos->ypos |= *cp++;
	tbpos->status = (byte >> 2) | TBINPROX;
	tbpos->scount++;
}

/*
 * Polhemus decode.
 */
static
poldecode(cp, polpos)
	register char *cp;
	register struct polpos *polpos;
{

	polpos->p_x = cp[4] | cp[3]<<7 | (cp[9] & 0x03) << 14;
	polpos->p_y = cp[6] | cp[5]<<7 | (cp[9] & 0x0c) << 12;
	polpos->p_z = cp[8] | cp[7]<<7 | (cp[9] & 0x30) << 10;
	polpos->p_azi = cp[11] | cp[10]<<7 | (cp[16] & 0x03) << 14;
	polpos->p_pit = cp[13] | cp[12]<<7 | (cp[16] & 0x0c) << 12;
	polpos->p_rol = cp[15] | cp[14]<<7 | (cp[16] & 0x30) << 10;
	polpos->p_stat = cp[1] | cp[0]<<7;
	if (cp[2] != ' ')
		polpos->p_key = cp[2];
}

#define TB_XY_BITS              0x3F
#define TB_BUTTONS              0x3C
 
/*
 * Decode tablet coordinates from binary data stream
 */
static calcomp_disc_decode(cp, tbpos)
        register char *cp;
        register struct tbmspos *tbpos;
{
/*
 *       SUPPORTS:                                                              
 *              CALCOMP 2000 Digitizer
 *              BIT PAD ONE Digitizer
 * 
 *      DATA FORMAT:
 *              MODIFIED BIT PAD ONE
 *
 *      Stop   P   6   5   4   3   2   1   0   Start
 *      Bit                                     Bit
 *      --------------------------------------------
 *      1      P   1   B4  B3  B2  B1  0   0     0
 *      1      P   0   X5  X4  X3  X2  X1  X0    0
 *      1      P   0   X11 X10 X9  X8  X7  X6    0
 *      1      P   0   Y5  Y4  Y3  Y2  Y1  Y0    0
 *      1      P   0   Y11 Y10 Y9  Y8  Y7  Y6    0
 *      --------------------------------------------
 *
 *      key:
 *
 *      P       = Parity (even)
 *      Bit 6   = Sync bit
 *                1 identifies first byte in the format;
 *                0 identifies subsequent bytes
 *      B1      = Button 1
 *      B2      = Button 2
 *      B3      = Button 3
 *      B4      = Button 4  (This button was added to data format)
 *      B1-B4   = Action Key indicators: 1 = key pressed
 *                                       0 = key not pressed
 *      X0-X11  = X Bits
 *      Y0-Y11  = Y Bits
 *      X0,Y0   = Least Significant Bit
 *
 */
 
        tbpos->status = ((*cp++) & TB_BUTTONS) >> 2;
 
        tbpos->xpos = ((*cp++) & TB_XY_BITS);
        tbpos->xpos |= ((*cp++) & TB_XY_BITS) << 6;
 
        tbpos->ypos = ((*cp++) & TB_XY_BITS);
        tbpos->ypos |= (*cp & TB_XY_BITS) << 6;

	return (1);
}

#ifndef SIGNEXTEND
#undef SIGNEXTEND
#endif


#define SIGNEXTEND(c)  ((int)(c)>=128 ? (int)(c)-256 : (int)(c))

#define MCS_BUTTONS_MASK	0x07
#define MCS_RIGHT_BUT		0x01
#define MCS_MIDDLE_BUT		0x02
#define MCS_LEFT_BUT		0x04

#define MCS_BIGSTEP		64


static pcmsdisc_decode(cp, tbpos)
        register char *cp;
        register struct tbmspos *tbpos;
{
/*
 *       SUPPORTS:                                                              
 *              PC MOUSE by Mouse Systems
 * 
 *      DATA FORMAT:
 *              8-BIT 3-BYTE BINARY DELTA
 *
 *      Stop   7   6   5   4   3   2   1   0   Start
 *      Bit                                     Bit
 *      --------------------------------------------
 *      1      1   0   0   0   0   L   M   R     0
 *      1      X7  X6  X5  X4  X3  X2  X1  X0    0
 *      1      Y7  Y6  Y5  Y4  Y3  Y2  Y1  Y0    0
 *      1      X7  X6  X5  X4  X3  X2  X1  X0    0
 *      1      Y7  Y6  Y5  Y4  Y3  Y2  Y1  Y0    0
 *      --------------------------------------------
 *
 *      key:
 *
 *      Bits 4-7  = Sync bits
 *                1000 -  identifies first byte in the format;

 *      L      = Left   Button
 *      M      = middle Button
 *      R      = Right  Button
 *      L,M,R  = Action Key indicators: 0 = key pressed
 *                                      1 = key not pressed

 *      X0-X7  = X Bits (2's complement)
 *      Y0-Y7  = Y Bits (2's complement)
 *      X0,Y0  = Least Significant Bit
 *
 */
	register short status;
	register short *pstatus;
	register int xpos = 0;
	register int ypos = 0;
	register    incr;
	int i;

	*(pstatus = &tbpos->status) = 0;
	status =  (~(*cp++)) & 7;

	if (status & MCS_LEFT_BUT)
		*pstatus |= LEFT_BUT;
	if (status & MCS_MIDDLE_BUT)
		*pstatus |= MIDDLE_BUT;
	if (status & MCS_RIGHT_BUT)
		*pstatus |= RIGHT_BUT;

	for (i = 1; i <= 4; i++) {
		if ((*cp > MCS_BIGSTEP) && (*cp < (256-MCS_BIGSTEP))) {
			tbpos->xpos = 0;
			tbpos->ypos = 0;
			return (0);
		}
		incr = *cp++;
		incr = SIGNEXTEND(incr);
		if (tb_debug & 0x01)
			printf ("TBED: incr (%d) xpos (%d) ypos (%d)\n",
				incr, xpos, ypos);

		switch (i) {
		case 1: 
		case 3: 
			xpos += incr;
			break;
		case 2: 
		case 4: 
			ypos -= incr;
			break;
		}
	}
	tbpos->xpos = xpos;
	tbpos->ypos = ypos;

	return (1);
}
#include <caio/mouseio.h>

#define XNEG		0x04
#define YNEG		0x02

#define BUT_MASK	0xA0
#define BUT_SHIFT	5
#define BUT_DEFS	"\20\01LEFT\02MIDDLE\03RIGHT"

#define SETTIMEOUT(a,b,c) {\
				ptp = tp; psi = si;\
				timeout(a,b,c);\
			}

int single_but = 0;
int lastbut = 0;
struct tty *ptp;
SCREEN_INFO *psi;

/* 3 Button Emulation for Planar Mouse */
static pmsdisc3_decode(cp, tbpos, tp, si)
        register char *cp;
        register struct tbmspos *tbpos;
	struct tty *tp;
	SCREEN_INFO *si;	
{
	register short status;
	register int xpos, ypos;
	int pollms();
	struct tb *tbp;

	

	tbp = (struct tb *) (tp->T_LINEP);

	/* Check if this was a poll timeout */
	if (cp == 0) {
		if (single_but) {
			if (++single_but > 2)
				single_but = 0;
			else
				SETTIMEOUT (pollms, tbpos, 2);
		}
		return(!single_but);
	}

	/* Check if both buttons are down and simulate a middle button */
	status = *++cp;
	if ((status & BUT_MASK) == BUT_MASK)
		tbpos->status = MIDDLE_BUT;
	else
		tbpos->status = ((status & BUT_MASK) >> BUT_SHIFT);

	/* Figure x delta */
	xpos = (*++cp)>>1;
        xpos = (status & XNEG)? (xpos) | 0xffffffC0 : (xpos);

	/* Figure y delta (negative since downward movement of mouse
	 * causes a negative delta and most applications wand that to be
	 * a possitive delta)
	 */
	ypos = (*++cp)>>1;
        ypos = -((status & YNEG)? (ypos) | 0xffffffC0 : (ypos));

	if (tb_debug & 0x01)
		printf ("TB: xpos (%d) ypos (%d)\n", xpos, ypos);

	tbpos->ypos = ypos;
	tbpos->xpos = xpos;
	
	if (tb_debug & 0x01)
		printf ("sb (%x) last (%b) cur (%b)\n", single_but, 
			lastbut, BUT_DEFS, tbpos->status, BUT_DEFS);
	if (!single_but && (lastbut != tbpos->status)) {
		if ((lastbut == MIDDLE_BUT) && (tbpos->status != NO_BUT)) {
			tbpos->status = MIDDLE_BUT;
			single_but = 0;
		} else if ((lastbut == NO_BUT)&&(tbpos->status != MIDDLE_BUT)) {
			SETTIMEOUT (pollms, tbpos, 4);
			single_but++;
		}
	} else if ((single_but) && (lastbut == tbpos->status)) {
		untimeout(pollms, tbpos);
		if (++single_but > 2)
			single_but = 0;
		else
			SETTIMEOUT (pollms, tbpos, 4);
	} else if (single_but) {
		untimeout(pollms, tbpos);
		single_but = 0;
		if (tbpos->status == NO_BUT) {
			/* Record the Previous down button */
			tbpos->status = lastbut;
			record_pos (tbp, tp, si);

			/* Record the up motion */
			tbp->curindex = (tbp->curindex + 1) % TBQUEUESIZE;
			tbpos = (struct tbmspos *) &tbp->rets[tbp->curindex];
			tbpos->xpos = tbpos->ypos = tbpos->status = 0;
		}
	}
	lastbut = tbpos->status;
	return(!single_but);
}

pollms (tbpos)
register struct tbmspos *tbpos;
{
	register struct tb *tbp;

	if (tb_debug & 0x01)
		printf ("In pollms\n");
	
	tbp = (struct tb *) (ptp->T_LINEP);
	if (pmsdisc3_decode (0, tbpos, ptp, psi)) {
		record_pos (tbp, ptp, psi);
	}
	/*msioctl (0,MSIC_READXY,0,0);	No polling until it is reliable*/
}

record_pos (tbp, tp, si)
struct tb *tbp;
struct tty *tp;
SCREEN_INFO *si;
{
	register struct tbmspos *tbpos = (struct tbmspos *) &(tbp->rets[tbp->curindex]);
	register int s;

	if (tb_debug & 0x02) {
		printf ("record_pos: status(BUT) (%b)\n", tbpos->status, BUT_DEFS);
		printf ("record_pos: tbpos(%x) curindex(%d)\n",tbpos,tbp->curindex);
	}
	tbpos->scount++;
	tbp->curindex = (tbp->curindex + 1) % TBQUEUESIZE;
	wakeup ((caddr_t)tbpos);

	/* Give the emulator the data */
	s = spl5();
	si->ine.intr_reason = E_INT_MOUSE;
	if ((*emulsw[si->ine.emulator].e_rint)(0, tp, si)) {
		tbp->lastindex = tbp->curindex;
	}
	splx(s);
}


/* 2 Button reporting for Planar Mouse */
static pmsdisc2_decode(cp, tbpos, tp, si)
        register char *cp;
        register struct tbmspos *tbpos;
{
	register short status;
	register int xpos, ypos;

	/* Return Generic Left and/or Right Button */
	status = *++cp;
	if ((status & BUT_MASK) == BUT_MASK)
		tbpos->status = LEFT_BUT | RIGHT_BUT;
	else
		tbpos->status = ((status & BUT_MASK) >> BUT_SHIFT);

	/* Figure x delta */
	xpos = (*++cp)>>1;
        xpos = (status & XNEG)? (xpos) | 0xffffffC0 : (xpos);

	/* Figure y delta (negative since downward movement of mouse
	 * causes a negative delta and most applications want that to be
	 * a possitive delta)
	 */
	ypos = (*++cp)>>1;
        ypos = -((status & YNEG)? (ypos) | 0xffffffC0 : (ypos));

	tbpos->ypos = ypos;
	tbpos->xpos = xpos;
	
	return(1);
}

#define SPLRETURN(r) { splx(s); return(r); }

/*ARGSUSED*/
tbioctl(tp, cmd, data, flag)
	struct tty *tp;
	caddr_t data;
{
	register struct tb *tbp = (struct tb *)tp->T_LINEP;

	switch (cmd) {

#if	CMUCS
	case TBIOGETC:
		*(int *)data = (tbconf == tbconf_acis);
		break;

	case TBIOSETC:
		tbconf = *(int *)data ? tbconf_acis : tbconf_bsd;
		break;
#endif	CMUCS

	case BIOGMODE:
		*(int *)data = tbp->tbflags & TBMODE;
		break;

	case BIOSTYPE:
		if (tbconf[*(int *)data & TBTYPE].tbc_recsize == 0 ||
		    tbconf[*(int *)data & TBTYPE].tbc_decode == 0)
			return (EINVAL);
		tbp->tbflags &= ~TBTYPE;
		tbp->tbflags |= *(int *)data & TBTYPE;
		/* fall thru... to set mode bits */

	case BIOSMODE: {
		register struct tbconf *tc;

		tbp->tbflags &= ~TBMODE;
		tbp->tbflags |= *(int *)data & TBMODE;
		tc = &tbconf[tbp->tbflags & TBTYPE];
		if (tbp->tbflags&TBSTOP) {
			if (tc->tbc_stop)
				ttyout(tc->tbc_stop, tp);
		} else if (tc->tbc_start)
			ttyout(tc->tbc_start, tp);
		if (tbp->tbflags&TBPOINT) {
			if (tc->tbc_point)
				ttyout(tc->tbc_point, tp);
		} else if (tc->tbc_run)
			ttyout(tc->tbc_run, tp);
		ttstart(tp);
		break;
	}

	case BIOGTYPE:
		*(int *)data = tbp->tbflags & TBTYPE;
		break;
	/* get mouse decode discipline number */
	case TBIOGETD:
		*(int *)data = tbp->tbflags & TBTYPE;
		break;

	/* set mouse decode discipline number */
	case TBIOSETD:
	{	
		register int save;
		save = tbp->tbflags & TBTYPE;
		/* Preserve other flags. */
		tbp->tbflags  = (*(int *)data & TBTYPE) | (tbp->tbflags & TBMODE);
		*(int *)data = save;
		if (tb_debug & 0x04)
			printf ("TBIOSETD: was (%d) is (%d)\n",
				save, tbp->tbflags & TBTYPE);
		break;
	}
	case TIOCSETD:
	case TIOCGETD:
	case TIOCGETP:
	case TIOCGETC:
		return (-1);		/* pass thru... */

	default:
		return (ENOTTY);
	}
	return (0);
}


tbselect(dev, rw)
	dev_t dev;
	int rw;
{
	register struct tty *tp = &cdevsw[major(dev)].d_ttys[minor(dev)];
	struct tb *tbp;
	int s = spl5();

	tbp = (struct tb *) (tp->T_LINEP);

	switch (rw) {

	case FREAD:
		if (tbp->curindex != tbp->lastindex)
			goto win;
#if	MACH
		if (tp->t_rsel)
#else	MACH
		if (tp->t_rsel && tp->t_rsel->p_wchan == (caddr_t)&selwait)
#endif	MACH
			tp->t_state |= TS_RCOLL;
		else
#if	MACH
			tp->t_rsel = (struct proc *)current_thread();
#else	MACH
			tp->t_rsel = u.u_procp;
#endif	MACH
		break;

	case FWRITE:
		goto win;
	}
	splx(s);
	return (0);
win:
	splx(s);
	return (1);
}
#endif NROMP_TB
