/*  vicio.h - describes io interface with the vic (B008) driver
 *
 *  Copyright 1989 Cornell University
 *
 *  %W% (Cornell Theory Center) %G%
 * 
 *  06/27/89 : Added VICIC_ANLYZ ioctl. (MRM)
 *  12/14/88 : created (MRM)
 */

#ifndef _IO
#ifdef KERNEL
#include "../h/ioctl.h"
#else
#include <sys/ioctl.h>
#endif
#endif

struct viciio {
	unsigned char vi_vreg;
	unsigned char vi_rgval;
};

/* B008 interrupt level */
#define VIC_SPL()	spl4()

/* vic ioctl's */
#define VICIC_RDREG	_IOWR(v, 0, struct viciio)	/* read dev register*/
#define VICIC_WRREG	_IOW(v, 1, struct viciio)	/* write dev register*/
#define VICIC_RESET	_IOW(v, 2, int)			/* Reset T800       */
#define VICIC_INTRPT	_IOW(v, 3, int)		/* cause int (after reset)  */
#define VICIC_ISTAT	_IOR(v, 4, int)		/* read input status reg    */
#define VICIC_OSTAT	_IOR(v, 5, int)		/* read output status reg   */
#define VICIC_BERROR	_IOR(v, 6, int)		/* read error               */
#define VICIC_DEBUG	_IOW(v, 7, int)		/* set debugging value      */
#define VICIC_FLUSH	_IOW(v, 8, int)		/* try to unjam driver      */
#define VICIC_ANLYZ	_IOW(v, 9, int)		/* assert/deassert Analyse  */
