/*  vicreg.h : Device registers for the vic driver.
 *
 *  Copyright 1989 Cornell University
 *
 *  %W% (Cornell Theory Center) %G%
 *
 *  12/22/88 created (MRM)
 */

/* B008 device registers */
struct vicdevice {
	u_char in_data;			/* Input data register    */
	u_char out_data;		/* Output data register   */
	u_char in_stat;			/* Input status register  */
	u_char out_stat;		/* Output status register */
	u_char nthng[12];		/* blank space in regs    */
	u_char rsterr;			/* reset register (wt)    */
					/* Error register (rd)    */
	u_char analyse;			/* analyse register (wt)  */
	u_char dma_req;			/* DMA request register   */
	u_char int_ctl;			/* Interrupt control reg  */
};

/* bits for status registers */
#define VICST_IORDY		0x01
#define VICST_INTENA		0x02
/* bits for interrupt register */
#define VICINT_DMA		0x01
#define VICINT_ERR		0x02
#define VICINT_OUT		0x04
#define VICINT_IN		0x08
/* values for DMA request register */
#define VICDMA_WRITE		0x00
#define VICDMA_READ		0x01
