#if	CMU
/*  
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/* 
 **********************************************************************
 * HISTORY
 * $Log:	dmap.h,v $
 * Revision 2.3  88/08/24  02:25:28  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:11:10  mwyoung]
 * 
 *
 * 25-Jan-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Upgraded to 4.3.
 *
 * 07-May-85  Mike Accetta (mja) at Carnegie-Mellon University
 *	Upgraded from 4.1BSD.  Carried over changes below:
 *	[V1(1)]
 *
 * 12-Apr-82  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS:  Increased NDMAP from 48 to 65 to support 32Mb.
 *
 **********************************************************************
 */
 
#ifdef	KERNEL
#include <cmucs.h>
#include <mach.h>
#endif	KERNEL
#endif	CMU
#if	MACH
#else	MACH
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)dmap.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Definitions for the mapping of vitual swap
 * space to the physical swap area - the disk map.
 */

#if	CMUCS
#define	NDMAP 		65	/* size of the swap area map */
#else	CMUCS
#define	NDMAP 		38	/* size of the swap area map */
#endif	CMUCS

struct	dmap
{
	swblk_t	dm_size;	/* current size used by process */
	swblk_t	dm_alloc;	/* amount of physical swap space allocated */
	swblk_t	dm_map[NDMAP];	/* first disk block number in each chunk */
};
#ifdef KERNEL
struct	dmap zdmap;
int	dmmin, dmmax, dmtext;
#endif

/*
 * The following structure is that ``returned''
 * from a call to vstodb().
 */
struct	dblock
{
	swblk_t	db_base;	/* base of physical contig drum block */
	swblk_t	db_size;	/* size of block */
};
#endif	MACH
