/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/* 
 **********************************************************************
 * HISTORY
 * $Log:	inode.h,v $
 * Revision 2.3  88/08/24  02:28:52  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:13:20  mwyoung]
 * 
 *
 * 25-May-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Use vm_info field regardless of which options are enabled.
 *
 * 27-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	MACH_NBC: add vm_info field which holds pointer to information
 *	about the potentially mapped files.
 *
 *  7-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Merge VICE changes -- include vice.h and change to #if VICE.
 *
 * 22-Jan-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	MACH_XP: Correct type for inode.pager field.
 *
 * 22-Dec-86  David L. Black (dlb) at Carnegie-Mellon University
 *	MULTIMAX: support Encore's fast symbolic links.
 *
 *  2-Dec-86  Jay Kistler (jjk) at Carnegie-Mellon University
 *	VICE: added i_rmt_dev field to "inode" struct;
 *	added vicemagic definitions.
 *
 * 21-Oct-86  Jonathan J. Chew at Carnegie-Mellon University
 *	Use romp definition of "i_size" and "di_size" fields in inode
 *	structure with 68000.
 *
 * 14-Oct-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Added changes for ns32000 byte ordering (from dlb).
 *
 * 31-May-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Set the pager_id field in the inode structure.  This is a back
 *	pointer to the real pager id which will allow for pager id's to
 *	be different than inode numbers.
 *
 * 25-Jan-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Upgraded to 4.3.
 *
 * 18-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	Added different definitions of i_size and di_size for Sailboat
 *	from IBM code under switch ROMP.  These differences are
 *	presumably because of byte ordering differences.
 *
 * 20-Jul-85  Mike Accetta (mja) at Carnegie-Mellon University
 *	CS_RFS:  Changed to declare cnamei() rather than namei.
 *	[V1(1)]
 *
 * 13-May-85  Mike Accetta (mja) at Carnegie-Mellon University
 *	Upgraded to 4.2BSD.  Carried over change below.
 *
 * 20-Feb-82  Mike Accetta (mja) at Carnegie-Mellon University
 *	CS_ICHK: Added iincr_chk() and idecr_chk() macros to modify inode
 *	reference counts and check for consistency (V3.04c).
 *
 **********************************************************************
 */
 
#ifdef	KERNEL
#include <cmucs.h>
#include <cmucs_rfs.h>
#include <mach.h>
#include <vice.h>

#include <cputypes.h>
#else	KERNEL
#include <sys/features.h>
#endif	KERNEL
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)inode.h	7.1 (Berkeley) 6/4/86
 */

/*
 * The I node is the focus of all file activity in UNIX.
 * There is a unique inode allocated for each active file,
 * each current directory, each mounted-on file, text file, and the root.
 * An inode is 'named' by its dev/inumber pair. (iget/iget.c)
 * Data in icommon is read in from permanent inode on volume.
 */

#if	CMUCS_RFS
/*
 *  The following macro is used to identify the special CMU file type which is
 *  currently used to implement remote node pointer files.
 */
#define	isesctype(ip)	\
	((ip)->i_gid == 64)
 
/*
 *  The following macro is used to distinguish the special CMU remote node pointer.
 */
#define	isrfslnk(ip)	\
	(isesctype(ip) && (((ip)->i_mode&(IFMT|IEXEC|(IEXEC>>3)|(IEXEC>>6))) == (IFREG|IEXEC)))
 
#endif	CMUCS_RFS
#define	NDADDR	12		/* direct addresses in inode */
#define	NIADDR	3		/* indirect addresses in inode */
#if	MULTIMAX
#define MAX_FASTLINK_SIZE	((NDADDR + NIADDR) * sizeof (daddr_t))
#endif	MULTIMAX

struct inode {
	struct	inode *i_chain[2];	/* must be first */
#if	MACH
	struct vm_info	*vm_info;	/* pointer to VM info structure */
#endif	MACH
	u_short	i_flag;
	u_short	i_count;	/* reference count */
	dev_t	i_dev;		/* device where inode resides */
	u_short	i_shlockc;	/* count of shared locks on inode */
	u_short	i_exlockc;	/* count of exclusive locks on inode */
	ino_t	i_number;	/* i number, 1-to-1 with device address */
	long	i_id;		/* unique identifier */
	struct	fs *i_fs;	/* file sys associated with this inode */
	struct	dquot *i_dquot;	/* quota structure controlling this file */
	struct	text *i_text;	/* text entry, if any (should be region) */
	union {
		daddr_t	if_lastr;	/* last read (read-ahead) */
		struct	socket *is_socket;
		struct	{
			struct inode  *if_freef;	/* free list forward */
			struct inode **if_freeb;	/* free list back */
		} i_fr;
	} i_un;
	struct 	icommon
	{
		u_short	ic_mode;	/*  0: mode and type of file */
		short	ic_nlink;	/*  2: number of links to file */
		uid_t	ic_uid;		/*  4: owner's user id */
		gid_t	ic_gid;		/*  6: owner's group id */
		quad	ic_size;	/*  8: number of bytes in file */
		time_t	ic_atime;	/* 16: time last accessed */
		long	ic_atspare;
		time_t	ic_mtime;	/* 24: time last modified */
		long	ic_mtspare;
		time_t	ic_ctime;	/* 32: last time inode changed */
		long	ic_ctspare;
#if	MULTIMAX
		union {
		    struct { 
			daddr_t	Mb_db[NDADDR]; /* 40: disk block addresses*/
			daddr_t	Mb_ib[NIADDR]; /* 88: indirect blocks */
		    } ic_Mb;
#define	ic_db	ic_Mun.ic_Mb.Mb_db
#define	ic_ib	ic_Mun.ic_Mb.Mb_ib
		    char	ic_Msymlink[MAX_FASTLINK_SIZE];
						/* 40: symbolic link name */
		} ic_Mun;
#define ic_symlink	ic_Mun.ic_Msymlink
#else	MULTIMAX
		daddr_t	ic_db[NDADDR];	/* 40: disk block addresses */
		daddr_t	ic_ib[NIADDR];	/* 88: indirect blocks */
#endif	MULTIMAX
		long	ic_flags;	/* 100: status, currently unused */
#if	MULTIMAX
#define	IC_FASTLINK	0x0001		/* Symbolic link in inode */
#endif	MULTIMAX
		long	ic_blocks;	/* 104: blocks actually held */
		long	ic_spare[5];	/* 108: reserved, currently unused */
	} i_ic;
#if	VICE
	dev_t	i_rmt_dev;	/* device for communications with an agent
				   process maintaining a remote fs */
#endif	VICE
};

struct dinode {
	union {
		struct	icommon di_icom;
		char	di_size[128];
	} di_un;
};

#define	i_mode		i_ic.ic_mode
#define	i_nlink		i_ic.ic_nlink
#define	i_uid		i_ic.ic_uid
#define	i_gid		i_ic.ic_gid
/* ugh! -- must be fixed */
#if	defined(vax) || defined(ns32000)
#define	i_size		i_ic.ic_size.val[0]
#endif	defined(vax) || defined(ns32000)
#if	defined(romp) || defined(mc68000)
#define i_size		i_ic.ic_size.val[1]
#endif	defined(romp) || defined(mc68000)
#define	i_db		i_ic.ic_db
#define	i_ib		i_ic.ic_ib
#if	MULTIMAX
#define	i_symlink	i_ic.ic_symlink
#define i_icflags	i_ic.ic_flags
#endif	MULTIMAX
#define	i_atime		i_ic.ic_atime
#define	i_mtime		i_ic.ic_mtime
#define	i_ctime		i_ic.ic_ctime
#define i_blocks	i_ic.ic_blocks
#define	i_rdev		i_ic.ic_db[0]
#define	i_lastr		i_un.if_lastr
#define	i_socket	i_un.is_socket
#define	i_forw		i_chain[0]
#define	i_back		i_chain[1]
#define	i_freef		i_un.i_fr.if_freef
#define	i_freeb		i_un.i_fr.if_freeb

#if	VICE
#define i_vicemagic	i_ic.ic_spare[0]
#define VICEMAGIC	0x84fa1cb6
#define i_vicep1	i_ic.ic_spare[1]
#define i_vicep2	i_ic.ic_spare[2]
#define i_vicep3	i_ic.ic_spare[3]
#define i_vicep4	i_ic.ic_spare[4]
#endif	VICE

#define di_ic		di_un.di_icom
#define	di_mode		di_ic.ic_mode
#define	di_nlink	di_ic.ic_nlink
#define	di_uid		di_ic.ic_uid
#define	di_gid		di_ic.ic_gid
#if	defined(vax) || defined(ns32000)
#define	di_size		di_ic.ic_size.val[0]
#endif	defined(vax) || defined(ns32000)
#if	defined(romp) || defined(mc68000)
#define di_size		di_ic.ic_size.val[1]
#endif	defined(romp) || defined(mc68000)
#define	di_db		di_ic.ic_db
#define	di_ib		di_ic.ic_ib
#if	MULTIMAX
#define	di_symlink	di_ic.ic_symlink
#define	di_icflags	di_ic.ic_flags
#endif	MULTIMAX
#define	di_atime	di_ic.ic_atime
#define	di_mtime	di_ic.ic_mtime
#define	di_ctime	di_ic.ic_ctime
#define	di_rdev		di_ic.ic_db[0]
#define	di_blocks	di_ic.ic_blocks
#if	VICE
#define di_vicemagic	di_ic.ic_spare[0]
#define di_vicep1	di_ic.ic_spare[1]
#define di_vicep2	di_ic.ic_spare[2]
#define di_vicep3	di_ic.ic_spare[3]
#define di_vicep4	di_ic.ic_spare[4]
#endif	VICE

#ifdef KERNEL
/*
 * Invalidate an inode. Used by the namei cache to detect stale
 * information. At an absurd rate of 100 calls/second, the inode
 * table invalidation should only occur once every 16 months.
 */
#define cacheinval(ip)	\
	(ip)->i_id = ++nextinodeid; \
	if (nextinodeid == 0) \
		cacheinvalall();

struct inode *inode;		/* the inode table itself */
struct inode *inodeNINODE;	/* the end of the inode table */
int	ninode;			/* number of slots in the table */
long	nextinodeid;		/* unique id generator */

struct	inode *rootdir;			/* pointer to inode of root directory */

struct	inode *ialloc();
struct	inode *iget();
#ifdef notdef
struct	inode *ifind();
#endif
struct	inode *owner();
struct	inode *maknode();
#if	CMUCS_RFS
struct	inode *cnamei();
#else	CMUCS_RFS
struct	inode *namei();
#endif	CMUCS_RFS

ino_t	dirpref();
#endif

/* flags */
#define	ILOCKED		0x1		/* inode is locked */
#define	IUPD		0x2		/* file has been modified */
#define	IACC		0x4		/* inode access time to be updated */
#define	IMOUNT		0x8		/* inode is mounted on */
#define	IWANT		0x10		/* some process waiting on lock */
#define	ITEXT		0x20		/* inode is pure text prototype */
#define	ICHG		0x40		/* inode has been changed */
#define	ISHLOCK		0x80		/* file has shared lock */
#define	IEXLOCK		0x100		/* file has exclusive lock */
#define	ILWAIT		0x200		/* someone waiting on file lock */
#if	VICE
#define IREMOTE		0x400		/* inode is remote.  Note, this
					   is only used for inodes that are
					   opened without a file descrip-
					   tor, by the kernel */
#endif	VICE
#define	IMOD		0x400		/* inode has been modified */
#define	IRENAME		0x800		/* inode is being renamed */

/* modes */
#define	IFMT		0170000		/* type of file */
#define	IFCHR		0020000		/* character special */
#define	IFDIR		0040000		/* directory */
#define	IFBLK		0060000		/* block special */
#define	IFREG		0100000		/* regular */
#define	IFLNK		0120000		/* symbolic link */
#define	IFSOCK		0140000		/* socket */

#define	ISUID		04000		/* set user id on execution */
#define	ISGID		02000		/* set group id on execution */
#define	ISVTX		01000		/* save swapped text even after use */
#define	IREAD		0400		/* read, write, execute permissions */
#define	IWRITE		0200
#define	IEXEC		0100

#define	ILOCK(ip) { \
	while ((ip)->i_flag & ILOCKED) { \
		(ip)->i_flag |= IWANT; \
		sleep((caddr_t)(ip), PINOD); \
	} \
	(ip)->i_flag |= ILOCKED; \
}

#define	IUNLOCK(ip) { \
	(ip)->i_flag &= ~ILOCKED; \
	if ((ip)->i_flag&IWANT) { \
		(ip)->i_flag &= ~IWANT; \
		wakeup((caddr_t)(ip)); \
	} \
}

#define	IUPDAT(ip, t1, t2, waitfor) { \
	if (ip->i_flag&(IUPD|IACC|ICHG|IMOD)) \
		iupdat(ip, t1, t2, waitfor); \
}
#if	CMUCS

/*
 *  Macros for modifying inode reference counts - used to check for consistency
 *  at each reference.
 *
 *  The idecr_chk() macro is defined such that it doesn't decrement the
 *  reference count when already zero.  This is in order to avoid the nested
 *  iincr panic which would otherwise occur when update() tries to sync the
 *  inode before halting and increments the count back to zero.
 *
 *  The panic message strings are initialized variables rather than constant
 *  strings since they are potentially used in many places.
 */
extern char *PANICMSG_IINCR;
extern char *PANICMSG_IDECR;

#define	iincr_chk(ip)	{ if (++((ip)->i_count) == 0) panic(PANICMSG_IINCR); }
#define	idecr_chk(ip)	{ if (((ip)->i_count) != 0) ((ip)->i_count--); else panic(PANICMSG_IDECR); }
#endif	CMUCS

#define	ITIMES(ip, t1, t2) { \
	if ((ip)->i_flag&(IUPD|IACC|ICHG)) { \
		(ip)->i_flag |= IMOD; \
		if ((ip)->i_flag&IACC) \
			(ip)->i_atime = (t1)->tv_sec; \
		if ((ip)->i_flag&IUPD) \
			(ip)->i_mtime = (t2)->tv_sec; \
		if ((ip)->i_flag&ICHG) \
			(ip)->i_ctime = time.tv_sec; \
		(ip)->i_flag &= ~(IACC|IUPD|ICHG); \
	} \
}
