/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	h/mach_param.h
 *	Author:	Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Copyright (C) 1986, Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Mach system sizing parameters
 *
 * HISTORY
 * $Log:	mach_param.h,v $
 * Revision 2.4  88/12/21  14:17:22  mja
 * 	Increased the number of PORT_MAX
 * 	[88/12/20  15:25:11  mrt]
 * 
 * Revision 2.3  88/08/24  02:33:34  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:16:09  mwyoung]
 * 
 * Revision 2.2  88/07/20  21:04:16  rpd
 *	Added definition of SET_MAX, the maximum number of sets allowed.
 * 
 * 19-Aug-87  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Made small kernel messages bigger under MACH_NP, because a lot
 *	of space is used by the netmsg header anyway.
 *
 * 14-Aug-87  Rick Rashid (rfr) at Carnegie-Mellon University
 *	Reduced TASK_CHUNK and THREAD_CHUNK.
 *
 *  3-Mar-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added KERN_MSG_SMALL_SIZE.
 *
 *  1-Jan-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Calculate PORT_MAX as dependent upon TASK_MAX and THREAD_MAX.
 *
 * 21-Sep-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added PORT_BACKLOG_MAX.
 *
 * 21-Sep-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Changed number of registered ports, to make the task structure
 *	power-of-two sized.  Don't ask.
 *
 * 31-Aug-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added TASK_PORT_REGISTER_MAX.
 *
 * 10-Aug-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added port parameters.
 *
 *  8-Aug-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added number of ports definition.
 *
 * 24-Jul-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Increase TASK parameters.
 *
 * 29-Jan-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created
 *
 */

#ifndef	_MACH_PARAM_
#define	_MACH_PARAM_

#ifdef	KERNEL
#include <mach_np.h>
#else	KERNEL
#include <sys/features.h>
#endif	KERNEL

#define	THREAD_MAX	512		/* Max number of threads */
#define	THREAD_CHUNK	64		/* Allocation chunk */

#define	TASK_MAX	512		/* Max number of tasks */
#define	TASK_CHUNK	64		/* Allocation chunk */

#define	PORT_MAX	((TASK_MAX * 3 + THREAD_MAX)	/* kernel */ \
				+ (THREAD_MAX * 2)	/* user */ \
				+ 10000)		/* slop for objects */
					/* Number of ports, system-wide */

#define SET_MAX		(TASK_MAX + THREAD_MAX + 100)
					/* Max number of port sets */

#define	PORT_BACKLOG_DEFAULT	5
#define	PORT_BACKLOG_MAX	16

#define	TASK_PORT_REGISTER_MAX	4	/* Number of "registered" ports */

#if	MACH_NP
#define	KERN_MSG_SMALL_SIZE	256	/* Size of small kernel message */
#else	MACH_NP
#define	KERN_MSG_SMALL_SIZE	128	/* Size of small kernel message */
#endif
			
#endif	_MACH_PARAM_
