/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	mfs.h
 *	Author:	Avadis Tevanian, Jr.
 *
 *	Copyright (C) 1987, Avadis Tevanian, Jr.
 *
 *	Header file for mapped file system support.
 *
 * HISTORY
 * $Log:	mfs.h,v $
 * Revision 2.4  88/10/18  03:38:49  mwyoung
 * 	Add pager_request port.
 * 	[88/09/18            mwyoung]
 * 
 * Revision 2.3  88/08/24  02:35:56  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:17:29  mwyoung]
 * 
 * Revision 2.2  88/07/17  19:01:33  mwyoung
 * Use new memory object types.
 * 
 *
 * 11-Jun-87  William Bolosky (bolosky) at Carnegie-Mellon University
 *	Changed pager_id to pager.
 *
 * 30-Apr-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Created.
 */

#ifndef	_MFS_
#define	_MFS_

#include <sys/types.h>
#include <sys/lock.h>
#include <sys/queue.h>

#include <vm/memory_object.h>
#include <vm/vm_object.h>

/*
 *	Associated with each mapped file is information about its
 *	corresponding VM window.  This information is kept in the following
 *	vm_info structure.
 */
struct vm_info {
	memory_object_t	pager;		/* memory object (global name) */
	memory_object_control_t
			pager_request;	/* control port (global name) */
	int		locker;		/* thread holding lock (debug) */
	short		map_count;	/* number of times mapped */
	short		use_count;	/* number of times in use */
	vm_offset_t	va;		/* mapped virtual address */
	vm_size_t	size;		/* mapped size */
	vm_offset_t	offset;		/* offset into file at va */
	vm_size_t	inode_size;	/* inode size (not reflected in ip) */
	lock_data_t	lock;		/* lock for changing window */
	vm_object_t	object;		/* object [for KERNEL flushing] */
	queue_chain_t	lru_links;	/* lru queue links */
	int		queued:1,	/* on lru queue? */
			mapped:1;	/* mapped into KERNEL VM? */
};

#define VM_INFO_NULL	((struct vm_info *) 0)
#endif	_MFS_
