/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * Mach Interface Generator errors
 *
 * $Header: mig_errors.h,v 2.2 88/07/20 21:05:51 rpd Exp $
 *
 * HISTORY
 * $Log:	mig_errors.h,v $
 * Revision 2.2  88/07/20  21:05:51  rpd
 * Added definition of mig_symtab_t.
 * 
 *  2-Dec-87  David Golub (dbg) at Carnegie-Mellon University
 *	Added MIG_ARRAY_TOO_LARGE.
 *
 * 25-May-87  Richard Draves (rpd) at Carnegie-Mellon University
 *	Added definition of death_pill_t.
 *
 * 31-Jul-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created.
 */
#ifndef	_MIG_ERRORS_H
#define	_MIG_ERRORS_H

#include <sys/kern_return.h>
#include <sys/message.h>

#define	MIG_TYPE_ERROR		-300		/* Type check failure */
#define	MIG_REPLY_MISMATCH	-301		/* Wrong return message ID */
#define	MIG_REMOTE_ERROR	-302		/* Server detected error */
#define	MIG_BAD_ID		-303		/* Bad message ID */
#define	MIG_BAD_ARGUMENTS	-304		/* Server found wrong arguments */
#define	MIG_NO_REPLY		-305		/* Server shouldn't reply */
#define	MIG_EXCEPTION		-306		/* Server raised exception */
#define	MIG_ARRAY_TOO_LARGE	-307		/* User specified array not large enough
						   to hold returned array */

typedef struct {
	msg_header_t	Head;
	msg_type_t	RetCodeType;
	kern_return_t	RetCode;
} death_pill_t;

typedef struct mig_symtab {
	char	*ms_routine_name;
	int	ms_routine_number;
#ifdef hc
	void
#else
	int
#endif
		(*ms_routine)();
} mig_symtab_t;

#endif	_MIG_ERRORS_H
