/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/**********************************************************************
 * HISTORY
 *  4-Mar-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added MSG_TYPE_RPC.
 *
 *  22-Dec-86 Mary Thompson
 *	defined MSG_TYPE_CAMELOT, and MSG_TYPE_ENCRYPTED
 *
 *  ABSTRACT:
 *    This file defines user msg types that may be ored into
 *    the msg_type field in a msg header. Values 0-5 are reserved
 *    for use by the kernel and are defined in message.h. 
 *
 */

#ifndef	_MSG_TYPE_
#define	_MSG_TYPE_	1

#define MSG_TYPE_CAMELOT	(1 << 6)
#define MSG_TYPE_ENCRYPTED	(1 << 7)
#define	MSG_TYPE_RPC		(1 << 8)	/* Reply expected */

#include <sys/message.h>

#endif	_MSG_TYPE_
