/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

#ifndef	_NOTIFY_
#define	_NOTIFY_	1

/*
 *	Kernel notification message definitions.
 *
 * HISTORY
 * $Log:	notify.h,v $
 * Revision 2.3  88/10/11  10:25:29  rpd
 * 	Added NOTIFY_PORT_DESTROYED.
 * 	[88/10/11  08:05:35  rpd]
 * 
 * Revision 2.2  88/08/24  02:37:53  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:19:20  mwyoung]
 * 
 *
 * 21-Nov-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added notification message structure definition.
 *
 * 01-Jul-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created, based on Accent values.
 */

#include <sys/message.h>

/*
 *	Notifications sent upon interesting system events.
 */

#define	NOTIFY_FIRST			0100
#define	NOTIFY_PORT_DELETED		( NOTIFY_FIRST + 001 )
#define	NOTIFY_MSG_ACCEPTED		( NOTIFY_FIRST + 002 )
#define	NOTIFY_OWNERSHIP_RIGHTS		( NOTIFY_FIRST + 003 )
#define	NOTIFY_RECEIVE_RIGHTS		( NOTIFY_FIRST + 004 )
#define	NOTIFY_PORT_DESTROYED		( NOTIFY_FIRST + 005 )
#define	NOTIFY_LAST			( NOTIFY_FIRST + 015 )

typedef struct {
	msg_header_t	notify_header;
	msg_type_t	notify_type;
	port_t		notify_port;
} notification_t;

#endif	_NOTIFY_
