/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * Port "kernel object" declarations
 *
 * HISTORY
 * $Log:	port_object.h,v $
 * Revision 2.2  88/08/24  02:38:50  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:19:51  mwyoung]
 * 
 *
 *  2-Jun-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created.
 */

#include <mach_net.h>

#ifndef	_PORT_OBJECT_
#define	_PORT_OBJECT_

typedef	enum {
		PORT_OBJECT_NONE,
#if	MACH_NET
		PORT_OBJECT_NET,
#endif	MACH_NET
		PORT_OBJECT_TASK,
		PORT_OBJECT_THREAD,
		PORT_OBJECT_PAGING_REQUEST,
		PORT_OBJECT_PAGER
} port_object_type_t;

typedef struct {
		port_object_type_t kp_type;
		int		kp_object;
} port_object_t;

#endif	_PORT_OBJECT_
