#if	CMU
/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	ptrace.h,v $
 * Revision 2.2  88/08/24  02:40:17  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:20:42  mwyoung]
 * 
 */
#ifdef	KERNEL
#include <cputypes.h>
#endif	KERNEL
#endif	CMU

/*
 * Copyright (c) 1980, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)ptrace.h	7.1 (Berkeley) 6/4/86
 */

#ifndef _PTRACE_
#define _PTRACE_

#define PT_TRACE_ME	0	/* child declares it's being traced */
#define PT_READ_I	1	/* read word in child's I space */
#define PT_READ_D	2	/* read word in child's D space */
#define PT_READ_U	3	/* read word in child's user structure */
#define PT_WRITE_I	4	/* write word in child's I space */
#define PT_WRITE_D	5	/* write word in child's D space */
#define PT_WRITE_U	6	/* write word in child's user structure */
#define PT_CONTINUE	7	/* continue the child */
#define PT_KILL		8	/* kill the child process */
#define PT_STEP		9	/* single step the child */

#if	MULTIMAX || (!defined(KERNEL) && defined(multimax))
#include <mmax/mmax_ptrace.h>
#endif	MULTIMAX || (!defined(KERNEL) && defined(multimax))

#endif
