/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	sched_prim.h
 *	Author:	David Golub
 *
 *	Scheduling primitive definitions file
 *
 * HISTORY
 * $Log:	sched_prim.h,v $
 * Revision 2.3  88/07/17  18:57:09  mwyoung
 * .
 * 
 * Revision 2.2.1.1  88/06/28  20:52:32  mwyoung
 * Added thread_wakeup_with_result routine; thread_wakeup
 * is a special case.
 * 
 *
 * 16-May-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added thread_wakeup_with_result routine; thread_wakeup
 *	is a special case.
 *
 * 16-Apr-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added THREAD_RESTART wait result value.
 *
 * 29-Feb-88  David Black (dlb) at Carnegie-Mellon University
 *	thread_setrun is now a real routine.
 *
 * 13-Oct-87  David Golub (dbg) at Carnegie-Mellon University
 *	Moved thread_will_wait and thread_go to sched_prim_macros.h,
 *	to avoid including thread.h everywhere.
 *
 *  5-Oct-87  David Golub (dbg) at Carnegie-Mellon University
 *	Created.  Moved thread_will_wait and thread_go here from
 *	mach_ipc.
 *
 */

/*
 *	Possible results of assert_wait - returned in
 *	current_thread()->wait_result.
 */
#define	THREAD_AWAKENED		0		/* normal wakeup */
#define	THREAD_TIMED_OUT	1		/* timeout expired */
#define	THREAD_INTERRUPTED	2		/* interrupted by clear_wait */
#define	THREAD_SHOULD_TERMINATE	3		/* thread should terminate */
#define	THREAD_RESTART		4		/* restart operation entirely */

/*
 *	Exported interface to sched_prim.c 
 */
void	sched_init();
void	assert_wait();
void	clear_wait();
void	thread_sleep();
void	thread_wakeup_with_result();
void	thread_block();
void	thread_switch();
void	thread_set_timeout();
void	thread_setrun();

/*
 *	Routines defined as macros
 */

#define	thread_wakeup(x)	thread_wakeup_with_result((x), THREAD_AWAKENED)
