/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 **********************************************************************
 * HISTORY
 * $Log:	systm.h,v $
 * Revision 2.4  88/08/24  02:45:36  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:23:41  mwyoung]
 * 
 *
 * 29-Mar-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	MACH: Eliminated unused variables.
 *
 * 19-Mar-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Make redefinitions of insque/remque always ifdef'ed on lint.
 *
 *  1-Feb-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Moved runrun and curpri definitions to sched.h for MACH.
 *
 * 19-Jan-86  David L. Black (dlb) at Carnegie-Mellon University
 *	MACH: runrun and curpri are now per cpu.  Removed
 *	runin, runout, wantin, and noproc.
 *
 * 17-Dec-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Removed declaration of icode under MACH.
 *
 * 12-Nov-86  David L. Black (dlb) at Carnegie-Mellon University
 *	ns32000: #ifdef lint'ed insque and remque casts.  These bogosities
 *	ought to be permanently #ifdef lint'ed for all systems.
 *
 *  7-Oct-86  David L. Black (dlb) at Carnegie-Mellon University
 *	Merged Multimax changes.
 *
 * 24-Sep-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Changed to directly import declaration of boolean.
 *
 * 29-Aug-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Converted from "bool" type to "boolean_t" where necessary.
 *
 * 16-Jul-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	MACH: Removed definitions of swapdev and argdev.
 *
 * 22-Mar-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Merged VM and Romp versions.
 *
 * 18-Feb-86  Bill Bolosky (bolosky) at Carnegie-Mellon University
 *	romp: Added new definition of icode[].
 *
 * 25-Jan-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Upgraded to 4.3.
 *
 *  4-Nov-85  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Add sy_parallel flag to the system call entries to specify
 *	whether or not the system call can be executed in parallel.
 *
 * 03-Aug-85  Mike Accetta (mja) at Carnegie-Mellon University
 *	CS_RPAUSE:  Added rpause() and fspause() declarations.
 *
 * 20-Jun-85  Mike Accetta (mja) at Carnegie-Mellon University
 *	CMUCS:  Added bootdev definition.
 *	[V1(1)]
 *
 **********************************************************************
 */
 
#ifdef	KERNEL
#include <cmucs.h>
#include <mach.h>
#endif	KERNEL

#if	MACH
#include <cpus.h>
#endif	MACH
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)systm.h	7.1 (Berkeley) 6/4/86
 */

#if	CMUCS
#include <sys/boolean.h>
#endif	CMUCS
/*
 * Random set of variables
 * used by more than one
 * routine.
 */
extern	char version[];		/* system version */

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch. It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major
 * device numbers.
 */
int	nblkdev;

/*
 * Number of character switch entries.
 * Set by cinit/prim.c
 */
int	nchrdev;

#if	MACH
#else	MACH
int	nswdev;			/* number of swap devices */
#endif	MACH
int	mpid;			/* generic for unique process id's */
#if	MACH
char	kmapwnt;		/* Make #if cleaner */
#else	MACH
char	runin;			/* scheduling flag */
char	runout;			/* scheduling flag */
int	runrun;			/* scheduling flag */
char	kmapwnt;		/* kernel map want flag */
char	curpri;			/* more scheduling */
#endif	MACH

int	maxmem;			/* actual max memory per process */
int	physmem;		/* physical memory on this CPU */

#if	MACH
#else	MACH
int	nswap;			/* size of swap space */
#endif	MACH
int	updlock;		/* lock for sync */
daddr_t	rablock;		/* block to be read ahead */
int	rasize;			/* size of block in rablock */
extern	int intstack[];		/* stack for interrupts */
dev_t	rootdev;		/* device of the root */
dev_t	dumpdev;		/* device to take dumps on */
long	dumplo;			/* offset into dumpdev */
#if	MACH
#else	MACH
dev_t	swapdev;		/* swapping device */
dev_t	argdev;			/* device for argument lists */
#endif	MACH

#if	MACH
#else	MACH
#if defined(vax) || defined(ns32000)
extern	int icode[];		/* user init code */
extern	int szicode;		/* its size */
#endif
#ifdef	romp
extern  short icode[];		/* user init code */
extern  int szicode;		/* its size */
#endif	romp
#endif	MACH

daddr_t	bmap();
caddr_t	calloc();
#if	MACH
#else	MACH
int	memall();
int	vmemall();
caddr_t	wmemall();
swblk_t	vtod();
#endif	MACH
#if	CMUCS
boolean_t	rpause();
boolean_t	fspause();
#endif	CMUCS

/*
 * Structure of the system-entry table
 */
extern struct sysent
{
#if	MACH
	short	sy_narg;		/* total number of arguments */
	short	sy_parallel;		/* can execute in parallel */
#else	MACH
	int	sy_narg;		/* total number of arguments */
#endif	MACH
	int	(*sy_call)();		/* handler */
} sysent[];

#if	MACH
char	*panicstr;
#else	MACH
int	noproc;			/* no one is running just now */
char	*panicstr;
int	wantin;
#endif	MACH
int	boothowto;		/* reboot flags, from console subsystem */
#if	CMUCS
int	show_space;
#endif	CMUCS
#if	CMUCS
u_long	bootdev;		/* boot device, from bootstrap subsystem */
#endif	CMUCS
int	selwait;

#if	MACH
#else	MACH
extern	char vmmap[];		/* poor name! */
#endif	MACH

#ifdef	lint
/* casts to keep lint happy */
#define	insque(q,p)	_insque((caddr_t)q,(caddr_t)p)
#define	remque(q)	_remque((caddr_t)q)
#endif	lint
