/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	sys/task_statistics
 *
 *	Task statistics structure and definitions.
 *
 *	The defintions in this file are exported to the user.  The kernel
 *	will translate its internal data structures to these structures
 *	as appropriate.
 *
 ************************************************************************
 * HISTORY
 * $Log:	task_statistics.h,v $
 * Revision 2.2  88/08/24  02:46:59  mwyoung
 * 	Adjusted include file references.
 * 	[88/08/17  02:24:28  mwyoung]
 * 
 *
 * 15-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Structure is obsolete - replaced by task_info (see
 *	sys/task_info.h).
 *
 *  9-Jul-87  Karl Hauth (hauth) at Carnegie-Mellon University
 *	Added text_size, stack_size and data_size fields.  Changed
 *	virtual_pages and resident_pages to sizes with the idea being
 *	that this will happen on a remote machine someday.
 *
 *  2-Jul-87  Karl Hauth (hauth) at Carnegie-Mellon University
 *	Added virtual_pages and	resident_pages fields.	Someday we will
 *	argue over this	interface long enough for it to firm up.
 *
 *  1-Jun-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Created.
 *
 ************************************************************************
 */

#ifndef	_TASK_STATISTICS_
#define	_TASK_STATISTICS_

#include <machine/vm_types.h>

struct xxx_task_statistics {
	int		state;		/* run state (see below) */
	int		flags;		/* various flags (see below) */
	long		faults;		/* number of page faults */
	long		zero_fills;	/* number of zero fill pages */
	long		reactivations;	/* number of reactivated pages */
	long		pageins;	/* number of actual pageins */
	long		cow_faults;	/* number of copy-on-write faults */
	long		messages_sent;	/* number of messages sent */
	long		messages_received; /* number of messages received */
	vm_size_t	virtual_size;	/* number of virtual pages */
	vm_size_t	resident_size;	/* number of resident pages */
};

typedef struct xxx_task_statistics	*xxx_task_statistics_t;
typedef struct xxx_task_statistics	xxx_task_statistics_data_t;

/*
 *	Task states (state field)
 */

#define TASK_RUNNING	1	/* task is running normally */
#define TASK_WAITING	2	/* task is waiting normally */
#define TASK_WILL_WAIT	3	/* task is about to wait */

/*
 *	Task flags (flags field)
 *
 *	(No applicable flags to export to user)
 */

#endif	_TASK_STATISTICS_
