/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 *	File:	sys/thread_statistics
 *
 *	Thread statistics structure and definitions.
 *
 *	The defintions in this file are exported to the user.  The kernel
 *	will translate its internal data structures to these structures
 *	as appropriate.
 *
 ************************************************************************
 * HISTORY
 * 15-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Obsolete - replaced by thread_info (see sys/thread_info.h).
 *
 *  1-Jun-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Created.
 *
 ************************************************************************
 */

#ifndef	_THREAD_STATISTICS_
#define	_THREAD_STATISTICS_

struct xxx_thread_statistics {
	int	state;		/* run state (see below) */
	int	flags;		/* various flags (see below) */
	int	cpu_usage;	/* scaled cpu usage percentage */
	int	user_time;	/* user run time */
	int	system_time;	/* system run time */
	int	priority;	/* scheduling priority */
};

typedef struct xxx_thread_statistics	*xxx_thread_statistics_t;
typedef struct xxx_thread_statistics	xxx_thread_statistics_data_t;

/*
 *	Thread states (state field).
 */

#define	THREAD_RUNNING		1	/* thread is running normally */
#define THREAD_STOPPED		2	/* thread is stopped */
#define THREAD_WAITING		3	/* thread is waiting normally */
#define THREAD_WILL_WAIT	4	/* thread is on a sleep queue, but is
					   still running */
/*
 *	Thread flags (flags field).
 */

#define	THREAD_IDLE		1	/* is this an idle thread? */
#define THREAD_SWAPPED		2	/* is this thread swapped? */

#endif	_THREAD_STATISTICS_
