/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * 21-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Created.
 *
 */

/*
 *	File:	sys/thread_swap.h
 *
 *	Declarations of thread swap_states and swapping routines.
 */

/*
 *	Swap states for threads.
 */
#define	TH_SW_UNSWAPPABLE	1	/* not swappable */
#define	TH_SW_IN		2	/* swapped in */
#define	TH_SW_GOING_OUT		3	/* being swapped out */
#define	TH_SW_WANT_IN		4	/* being swapped out, but should
					   immediately be swapped in */
#define	TH_SW_OUT		5	/* swapped out */
#define	TH_SW_COMING_IN		6	/* queued for swapin, or being
					   swapped in */

/*
 *	exported routines
 */
void	swapper_init();
void	thread_swapin( /* thread_t thread */ );
void	swapin_thread();
void	swapout_threads();
void	swapout_thread();
void	thread_swappable( /* thread_t thread, boolean_t swappable */ );
void	thread_doswapin( /* thread_t thread */ );
