/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	ipc_netport.h
 * Purpose:
 *	Header file for mach_ipc_netport option.
 *
 * HISTORY
 * $Log:	ipc_netport.h,v $
 * Revision 2.3  88/09/25  22:12:16  rpd
 * 	Changed includes to the new style.
 * 	[88/09/19  16:17:50  rpd]
 * 
 * Revision 2.2  88/08/06  18:17:55  rpd
 * Created from kern/mach_ipc_netport.h.
 * 17-Jan-88 Daniel Julin (dpj) at Carnegie-Mellon University
 * 
 *	Renamed from mach_ipc_vmtp.h.
 *	Added definition for TCP control header, and IPC_, 
 *	DISP_, TR_ codes. Added transport_switch.
 *	Added DISP_IPC_ABORT.
 *
 * 30-Aug-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Corrected to only export those things required for the kernel
 *	interface (unless IPC_NETPORT_EXPORTS is defined, in case
 *	anyone cares).
 *
 *  9-Jul-87  Rick Rashid (rfr) at Carnegie-Mellon University
 *	Created.
 *
 */

#ifndef	_IPC_NETPORT_H_
#define _IPC_NETPORT_H_

typedef unsigned long	netaddr_t;

/*
 * Network Port structure.
 */
typedef struct {
    long	np_uid_high;
    long	np_uid_low;
} np_uid_t;

typedef struct {
    netaddr_t	np_receiver;
    netaddr_t	np_owner;
    np_uid_t	np_puid;
    np_uid_t	np_sid;
} network_port_t;

#if	defined(KERNEL) || defined(IPC_NETPORT_EXPORTS)
#include <sys/boolean.h>
#include <sys/message.h>

/*
 * Debugging flags.
 */
extern int		np_flags;
#define	NP_DEBUG	0x1
#define	NP_SODEBUG	0x2
#define	NP_TRACE	0x3


/*
 * Values for src_format
 */
#define DISP_FMT_NETWORK	0
#define DISP_FMT_VL_1		1	/* Vax order, long align */
#define DISP_FMT_NL_1		2	/* Non-vax order, long align */
#define DISP_FMT_MAX		(2 + 1)

/*
 * Format of the messages generated by servers on different machine types.
 */
#ifdef vax
#define	CONF_OWN_FORMAT		DISP_FMT_VL_1
#define	LongAlign		1
#define	VaxOrder		1
#endif vax

#ifdef romp
#define CONF_OWN_FORMAT		DISP_FMT_NL_1
#define	LongAlign		1
#define	VaxOrder		0
#endif romp

#ifdef sun
#define CONF_OWN_FORMAT		DISP_FMT_NL_1
#define	LongAlign		1
#define	VaxOrder		0
#endif sun

typedef struct {
    unsigned short	disp_type;		/* type of message (network format) */
    unsigned short	src_format;		/* format for all following data */
} disp_hdr_t, *disp_hdr_ptr_t;

/*
 * Values for disp_type
 */
#define DISP_IPC_MSG		1
#define DISP_IPC_UNBLOCK	2
#define DISP_PORTCHECK		3
#define DISP_NETNAME		4
#define DISP_PO_RO_HINT		5
#define DISP_PO_RO_XFER		6
#define DISP_PO_TOKEN		7
#define DISP_PO_DEATH		8
#define DISP_PORTSEARCH		9
#define DISP_PS_AUTH		10
#define DISP_STARTUP		11
#define	DISP_IPC_ABORT		12
#define DISP_TYPE_MAX		(12 + 1)


/*
 * Return codes for request-response interactions.
 */
#define	DISP_WILL_REPLY		0
#define DISP_FAILURE		-1
#define DISP_SUCCESS		-2
#define DISP_IGNORE		-3
#define	TR_SUCCESS		-10
#define	TR_FAILURE		-11
#define TR_REMOTE_ACCEPT	-12
#define	TR_REMOTE_REJECT	-13
#define TR_CRYPT_FAILURE	-14
#define TR_SEND_FAILURE		-15
#define	TR_OVERLOAD		-16
#define	IPC_SUCCESS		1
#define	IPC_FAILURE		2
#define	IPC_PORT_BLOCKED	3
#define	IPC_PORT_NOT_HERE	4
#define IPC_BAD_SEQ_NO		5
#define	IPC_REQUEST		6
#define	IPC_ABORT_REPLY		7
#define	IPC_ABORT_REQUEST	8
#define	IPC_PORT_BUSY		9
#define	IPC_ABORT_REQUEST_FLUSH	10
#define	IPC_ABORT_CLIENT	11


typedef network_port_t *network_port_ptr_t;

typedef union {
    struct {
	unsigned char ia_net_owner;
	unsigned char ia_net_node_type;
	unsigned char ia_host_high;
	unsigned char ia_host_low;
    } ia_bytes;
    netaddr_t ia_netaddr;
} ip_addr_t;

/*
 * Header for network IPC messages 
 */
typedef struct {
	disp_hdr_t      disp_hdr;	/* dispatcher header */
	network_port_t  local_port;
	network_port_t  remote_port;
	unsigned long   info;		/* info bits */
	unsigned long   npd_size;	/* size of Network Port Dictionary */
	unsigned long   inline_size;	/* size of inline part of message */
	unsigned long   ool_size;	/* size of ool part of message */
	unsigned long   ool_num;	/* number of ool sections (for assembly) */
	unsigned long	ipc_seq_no;	/* the IPC sequence number of this message */
}               ipc_network_hdr_t;

/*
 * Header and IPC message:
 */
typedef struct {
	disp_hdr_t      disp_hdr;	/* dispatcher header */
	network_port_t  local_port;
	network_port_t  remote_port;
	unsigned long   info;		/* info bits */
	unsigned long   npd_size;	/* size of Network Port Dictionary */
	unsigned long   inline_size;	/* size of inline part of message */
	unsigned long   ool_size;	/* size of ool part of message */
	unsigned long   ool_num;	/* number of ool sections (for assembly) */
	unsigned long	ipc_seq_no;	/* the IPC sequence number of this message */
	msg_header_t	kmsg_header;
}               ipc_netmsg_hdr_t;

/*
 * Bits for info field 
 */
#define IPC_INFO_SIMPLE		0x1
#define	IPC_INFO_RPC		0x2

/*
 * Macro to test for network port equality.
 */
#define NPORT_EQUAL(nport1,nport2) (					\
	((nport1).np_puid.np_uid_high == (nport2).np_puid.np_uid_high)	\
	&& ((nport1).np_puid.np_uid_low == (nport2).np_puid.np_uid_low)	\
	&& ((nport1).np_sid.np_uid_low == (nport2).np_sid.np_uid_low)	\
	&& ((nport1).np_sid.np_uid_low == (nport2).np_sid.np_uid_low))


/*
 * TCP control messages.
 */
#define	TCP_CTL_REQUEST		1
#define	TCP_CTL_REPLY		2
#define	TCP_CTL_CLOSEREQ	3
#define	TCP_CTL_CLOSEREP	4

typedef struct tcp_ctl {
	int		ctl;
	unsigned long	trid;
	int		code;
	unsigned long	size;
	int		crypt_level;
} tcp_ctl_t, *tcp_ctl_ptr_t;

#define	NETPORT_MSG_SIZE_MAX	(8 * 1024)

/*
 * Transport modules entry points.
 */
#define	TR_TCP_ENTRY	0
#define	TR_VMTP_ENTRY	1
#define	TR_MAX_ENTRY	2
typedef struct {
    int		(*sendrequest)();
    int		(*sendreply)();
} transport_sw_entry_t;
extern transport_sw_entry_t transport_switch[TR_MAX_ENTRY];


/*
 * Transport ID's for both TCP and VMTP.
 */
typedef struct {
	unsigned long	v1;
	unsigned long	v2;
} trid_t;


#endif	defined(KERNEL) || defined(IPC_NETPORT_EXPORTS)
#endif	_IPC_NETPORT_H_
