/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	ipc_pobj.h,v $
 * Revision 2.3  88/09/25  22:12:26  rpd
 * 	Changed includes to the new style.
 * 	[88/09/19  16:18:35  rpd]
 * 
 * Revision 2.2  88/08/06  18:18:47  rpd
 * Hacked convert_{task,thread}_to_port to return port_t, to agree with usage
 * everywhere, although they really return kern_port_t.
 * Added include of sys/kern_port.h.
 * Created.
 * 
 */ 

#ifndef	_IPC_POBJ_
#define	_IPC_POBJ_	1

#include <sys/port.h>
#include <sys/port_object.h>
#include <sys/task.h>
#include <sys/thread.h>
#include <vm/vm_map.h>

extern void port_object_set();
extern int port_object_get();
extern port_object_type_t port_object_type();

extern task_t convert_port_to_task();
extern thread_t convert_port_to_thread();
extern vm_map_t convert_port_to_map();
extern port_t convert_task_to_port();
extern port_t convert_thread_to_port();

#endif	_IPC_POBJ_
