/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	ipc_ptraps.c
 * Purpose:
 *	Task & thread port traps.
 *
 * HISTORY
 * $Log:	ipc_ptraps.c,v $
 * Revision 2.3  88/09/25  22:13:24  rpd
 * 	Changed includes to the new style.
 * 	[88/09/19  16:21:59  rpd]
 * 
 * Revision 2.2  88/08/06  18:20:16  rpd
 * Fixed to do locking and handle PORT_NULL gracefully.
 * Created.
 * 
 */

#include <sys/port.h>
#include <sys/task.h>
#include <sys/thread.h>
#include <sys/kern_port.h>
#include <kern/ipc_copyout.h>
#include <kern/ipc_ptraps.h>

/*
 *	Routines:	task_self, task_notify, thread_self, thread_reply
 *			[exported, trap]
 *	Purpose:
 *		Primitive traps that provide the currently-executing
 *		task/thread with one of its ports.
 */

#define	TASK_TRAP(port_to_get)						\
port_name_t								\
port_to_get()								\
{									\
	register task_t self = current_thread()->task;			\
	register kern_port_t port;					\
	port_name_t name;						\
									\
	ipc_task_lock(self);						\
	port = (kern_port_t) self->port_to_get;				\
	if (port != KERN_PORT_NULL)					\
		port_reference(port);					\
	ipc_task_unlock(self);						\
									\
	if (port != KERN_PORT_NULL)					\
		object_copyout(self, &port->port_obj,			\
			       MSG_TYPE_PORT, &name);			\
	else								\
		name = PORT_NULL;					\
									\
	return name;							\
}

TASK_TRAP(task_self)
TASK_TRAP(task_notify)

#define	THREAD_TRAP(port_to_get)					\
port_name_t								\
port_to_get()								\
{									\
	register thread_t self = current_thread();			\
	register kern_port_t port;					\
	port_name_t name;						\
									\
	ipc_thread_lock(self);						\
	port = (kern_port_t) self->port_to_get;				\
	if (port != KERN_PORT_NULL)					\
		port_reference(port);					\
	ipc_thread_unlock(self);					\
									\
	if (port != KERN_PORT_NULL)					\
		object_copyout(self->task, &port->port_obj,		\
			       MSG_TYPE_PORT, &name);			\
	else								\
		name = PORT_NULL;					\
									\
	return name;							\
}

THREAD_TRAP(thread_self)
THREAD_TRAP(thread_reply)
