/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	ipc_statistics.c
 * Purpose:
 *	Code for IPC statistics gathering.
 *
 * HISTORY
 * $Log:	ipc_statistics.c,v $
 * Revision 2.8  89/01/15  16:23:40  rpd
 * 	Use decl_simple_lock_data.
 * 	[89/01/15  15:00:44  rpd]
 * 
 * Revision 2.7  89/01/12  07:56:09  rpd
 * 	Moved ipc_statistics.h to mach_debug/.  Added MACH_DEBUG conditionals.
 * 	[89/01/12  04:46:45  rpd]
 * 
 * Revision 2.6  89/01/10  23:30:22  rpd
 * 	Added locking around the ipc_statistics structure.
 * 	[89/01/10  23:05:09  rpd]
 * 
 * Revision 2.5  88/12/19  02:45:29  mwyoung
 * 	Remove lint.
 * 	[88/12/08            mwyoung]
 * 
 * Revision 2.4  88/10/11  10:18:41  rpd
 * 	When resetting IPC statistics, don't change current.
 * 	[88/10/10  07:58:08  rpd]
 * 
 * Revision 2.3  88/09/25  22:13:57  rpd
 * 	Changed includes to the new style.
 * 	Added host_ipc_statistics_reset.
 * 	[88/09/09  04:42:43  rpd]
 * 
 * Revision 2.2  88/07/22  07:32:31  rpd
 * Created for Mach IPC statistics functions.
 * 
 */

#include <mach_debug.h>

#include <sys/kern_return.h>
#include <sys/task.h>
#include <sys/lock.h>
#include <mach_debug/ipc_statistics.h>

decl_simple_lock_data(,ipc_statistics_lock_data)
ipc_statistics_t ipc_statistics;

/*
 *	Routine:	ipc_stats_init [exported]
 *	Purpose:
 *		Initialize Mach IPC statistics gathering.
 */
void
ipc_stats_init()
{
	simple_lock_init(&ipc_statistics_lock_data);

	ipc_statistics.version = 77;
	ipc_statistics.messages = 0;
	ipc_statistics.complex = 0;
	ipc_statistics.kernel = 0;
	ipc_statistics.large = 0;
	ipc_statistics.current = 0;
	ipc_statistics.emergency = 0;
	ipc_statistics.notifications = 0;
	ipc_statistics.port_copyins = 0;
	ipc_statistics.port_copyouts = 0;
	ipc_statistics.port_copyin_hits = 0;
	ipc_statistics.port_copyout_hits = 0;
	ipc_statistics.port_allocations = 0;
	ipc_statistics.bucket_misses = 0;
	ipc_statistics.ip_data_grams = 0;
}

#if	MACH_DEBUG
/*
 *	Routine:	host_ipc_statistics [exported, user]
 *	Purpose:
 *		Return the accumulated IPC statistics.
 */
kern_return_t
host_ipc_statistics(target_task, statistics)
	task_t target_task;
	ipc_statistics_t *statistics;
{
#ifdef	lint
	target_task++;
#endif	lint

	ipc_statistics_lock();
	*statistics = ipc_statistics;
	ipc_statistics_unlock();

	return KERN_SUCCESS;
}

/*
 *	Routine:	host_ipc_statistics_reset [exported, user]
 *	Purpose:
 *		Reset the accumulated IPC statistics.
 */
kern_return_t
host_ipc_statistics_reset(target_task)
	task_t target_task;
{
#ifdef	lint
	target_task++;
#endif	lint

	ipc_statistics_lock();
	ipc_statistics.messages = 0;
	ipc_statistics.complex = 0;
	ipc_statistics.kernel = 0;
	ipc_statistics.large = 0;
	ipc_statistics.emergency = 0;
	ipc_statistics.notifications = 0;
	ipc_statistics.port_copyins = 0;
	ipc_statistics.port_copyouts = 0;
	ipc_statistics.port_copyin_hits = 0;
	ipc_statistics.port_copyout_hits = 0;
	ipc_statistics.port_allocations = 0;
	ipc_statistics.bucket_misses = 0;
	ipc_statistics.ip_data_grams = 0;
	ipc_statistics_unlock();

	return KERN_SUCCESS;
}
#endif	MACH_DEBUG
