/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 * HISTORY
 * $Log:	mach_traps.h,v $
 * Revision 2.2  89/01/15  16:24:46  rpd
 * 	Updated includes for the new mach/ directory.
 * 	[89/01/15  15:03:03  rpd]
 * 
 * 18-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Add thread_reply.  Leave in task_data as an alternate name -
 *	they are functionally indistinguishable.
 *
 * 15-Oct-86  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Include ../kern/mach_types.h instead of <kern/mach_types.h> when
 *	building for the kernel.
 *
 *  1-Sep-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Created, mostly to help build the lint library.
 *	Should eventually include this in "syscall_sw.c".
 *
 */

/*
 *	Definitions of general Mach system traps.
 *
 *	IPC traps are defined in <sys/message.h>.
 *	Kernel RPC functions are defined in <kern/mach.h>.
 */

#ifndef	_MACH_TRAPS_
#define	_MACH_TRAPS_	1

#define	_MACH_INIT_	1

#include <mach/mach_types.h>

#ifdef	KERNEL
port_t		task_self
#else	KERNEL
task_t		task_self
#endif	KERNEL
#ifdef	LINTLIBRARY
			()
	 { return(PORT_NULL); }
#else	LINTLIBRARY
			();
#endif	LINTLIBRARY

port_t		task_data
#ifdef	LINTLIBRARY
			()
	 { return(PORT_NULL); }
#else	LINTLIBRARY
			();
#endif	LINTLIBRARY

port_t		task_notify
#ifdef	LINTLIBRARY
			()
	 { return(PORT_NULL); }
#else	LINTLIBRARY
			();
#endif	LINTLIBRARY

#ifdef	KERNEL
port_t		thread_self
#else	KERNEL
thread_t	thread_self
#endif	KERNEL
#ifdef	LINTLIBRARY
			()
	 { return(PORT_NULL); }
#else	LINTLIBRARY
			();
#endif	LINTLIBRARY

port_t		thread_reply
#ifdef	LINTLIBRARY
			()
	 { return(PORT_NULL); }
#else	LINTLIBRARY
			();
#endif	LINTLIBRARY

#endif	_MACH_TRAPS_
