/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	mig_support.c,v $
 * Revision 2.3  89/01/15  16:25:57  rpd
 * 	Updated includes for the new mach/ directory.
 * 	[89/01/15  15:05:21  rpd]
 * 
 * Revision 2.2  88/07/17  19:04:52  mwyoung
 * .
 * 
 * Revision 2.1.1.1  88/06/28  20:39:03  mwyoung
 * Include <sys/thread.h> to get current_task().
 * 
 *
 * 18-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Changed task_data to thread_reply.
 *
 */
/*
 *	File:	kern/mig_support.c
 *
 *	Support for the Mach Interface Generator, as required
 *	for built-in tasks.
 */

#define _MACH_INIT_
#include <sys/task.h>
#include <sys/thread.h>
#include <mach/mach_user_internal.h>

port_t mig_get_reply_port()
{
	if (current_task()->reply_port == PORT_NULL) {
		current_task()->reply_port = thread_reply();
		port_allocate(task_self(), &(current_task()->reply_port));
	}
	return(current_task()->reply_port);
}

void mig_dealloc_reply_port()
{
	printf("mach_user_internal: deallocate\n");
}
