/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	syscall_sw.h,v $
 * Revision 2.4  88/10/27  10:48:53  rpd
 * 	Changed msg_{send,receive,rpc}_trap to 20, 21, 22.
 * 	Added a bunch of mach_sctimes syscalls.
 * 	[88/10/26  14:45:13  rpd]
 * 
 * Revision 2.3  88/10/11  10:21:04  rpd
 * 	Changed traps msg_send, msg_receive_, msg_rpc_ to
 * 	msg_send_old, msg_receive_old, msg_rpc_old.
 * 	Added msg_send_trap, msg_receive_trap, msg_rpc_trap.
 * 	[88/10/06  12:24:33  rpd]
 * 
 * 20-Apr-88  David Black (dlb) at Carnegie-Mellon University
 *	Removed thread_times().
 *
 * 18-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Replaced task_data with thread_reply; change is invisible to
 *	users.  Carried over Mary Thompson's change below:
 *
 * Mary Thompson (originally made 19-May-87 in /usr/mach/include)
 *	Went back to old msg_receive_ and msg_rpc_ traps
 *	so that the library would work with the standard kernels
 *
 * 01-Mar-88  Douglas Orr (dorr) at Carnegie-Mellon University
 *	Add htg_unix_syscall
 *
 * 15-May-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	LOCORE -> ASSEMBLER.  Removed unnecessary conditional
 *	compilation (assumes MACH to the full extent).
 *
 *  8-Apr-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Change name for "msg_receive" to "msg_receive_", to enable user
 *	library to loop looking for software interrupt condition.
 *	Same for msg_rpc.
 *
 * 30-Mar-87  David Black (dlb) at Carnegie-Mellon University
 *	Added kern_timestamp()
 *
 * 27-Mar-87  David Black (dlb) at Carnegie-Mellon University
 *	Added thread_times for MACH_TIME_NEW.  Flushed MACH_TIME.
 *
 * 25-Mar-87  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Added map_fd, deleted DEFUNCT code.
 *
 * 18-Feb-87  Robert Baron (rvb) at Carnegie-Mellon University
 * 	Added # args to the kernel_trap() macro.
 *	Balance needs to know # of args passed to trap routine
 *
 *  4-Feb-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added ctimes().
 *
 *  7-Nov-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added "init_process".
 *
 *  4-Nov-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Removed some old Accent calls; they should be supplanted by
 *	library conversion routines to Mach calls.
 *
 * 29-Oct-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Put swtch under MACH_MP; added inode_swap_preference.
 *
 * 12-Oct-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Added traps for msg_send, msg_receive, msg_rpc, under
 *	either MACH_ACC or MACH_IPC.  Removed unused calls.
 *	Restructured and renamed trap table.
 *
 *  1-Sep-86  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Moved stuff from user source directory back here, and into
 *	<machine/syscall_sw.h>.  It's only natural that the kernel
 *	sources describe what traps exist, and how they're made.
 */

#ifndef	_SYSCALL_SW_
#define	_SYSCALL_SW_	1

#ifdef	KERNEL
#ifndef ASSEMBLER
typedef struct {
	short		mach_trap_length;
	short		mach_trap_flags;
	int		(*mach_trap_function)();
} mach_trap_t;
extern mach_trap_t	mach_trap_table[];
extern int		mach_trap_count;

#define	MACH_TRAP(name, arg_count, flags)	{ sizeof(int) * ((arg_count)+1), (flags), (name) }
#define	FF1(name,argno,flags)	MACH_TRAP(name, argno, 1<<flags)
#define	FN(name, argno)		MACH_TRAP(name, argno, 0)

#endif	ASSEMBLER

/*
 *	Flag values (actually bit numbers)
 */

#define ASETJMP		0
#define APSIG		2

#else	KERNEL

/*
 *	The machine-dependent "syscall_sw.h" file should
 *	define a macro for
 *		kernel_trap(trap_name, trap_number, arg_count)
 *	which will expand into assembly code for the
 *	trap.
 *
 *	N.B.: When adding calls, do not put spaces in the macros.
 */

#include <machine/syscall_sw.h>

/*
 *	These trap numbers should be taken from the
 *	table in "../kern/syscall_sw.c".
 */

kernel_trap(task_self,-10,0)
kernel_trap(task_data,-11,0)		/* OBSOLETE */
kernel_trap(thread_reply,-11,0)
kernel_trap(task_notify,-12,0)
kernel_trap(thread_self,-13,0)
kernel_trap(msg_send_old,-14,3)
kernel_trap(msg_receive_old,-15,3)
kernel_trap(msg_rpc_old,-16,5)
kernel_trap(msg_send_trap,-20,4)
kernel_trap(msg_receive_trap,-21,5)
kernel_trap(msg_rpc_trap,-22,6)

kernel_trap(InitPort,-22,2)
kernel_trap(SoftEnable,-29,2)
kernel_trap(MessagesWaiting,-31,4)
kernel_trap(task_by_pid,-33,1)
kernel_trap(ns_port,-80,0)

kernel_trap(kern_timestamp,-51,1)

kernel_trap(htg_unix_syscall,-52,3);

kernel_trap(swtch_pri,-59,1)
kernel_trap(swtch,-60,0)

kernel_trap(inode_swap_preference,-40,3)

kernel_trap(init_process,-41,0)
kernel_trap(ctimes,-42,2)
kernel_trap(map_fd,-43,5)

kernel_trap(mach_sctimes_0,-70,0)
kernel_trap(mach_sctimes_1,-71,1)
kernel_trap(mach_sctimes_2,-72,2)
kernel_trap(mach_sctimes_3,-73,3)
kernel_trap(mach_sctimes_4,-74,4)
kernel_trap(mach_sctimes_5,-75,5)
kernel_trap(mach_sctimes_6,-76,6)

kernel_trap(mach_sctimes_7,-77,0)
kernel_trap(mach_sctimes_8,-78,6)

kernel_trap(mach_sctimes_9,-79,1)
kernel_trap(mach_sctimes_10,-80,2)
kernel_trap(mach_sctimes_11,-81,2)
#endif	KERNEL

#endif	_SYSCALL_SW_
