/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	File:	kern/mach_types.h
 *	Author:	Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Copyright (C) 1986, Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Mach external interface definitions.
 *
 * HISTORY
 * $Log:	mach_types.h,v $
 * Revision 2.2  89/01/15  16:30:50  rpd
 * 	Moved from kern/ to mach/.
 * 	[89/01/15  14:35:53  rpd]
 * 
 * Revision 2.10  89/01/12  11:15:18  rpd
 * 	Removed pointer_t declaration; it belongs in std_types.h.
 * 
 * Revision 2.9  89/01/12  07:57:53  rpd
 * 	Moved basic stuff to std_types.h.  Removed debugging definitions.
 * 	Moved io_buf definitions to device_types.h.
 * 	[89/01/12  04:51:54  rpd]
 * 
 * Revision 2.8  89/01/04  13:37:34  rpd
 * 	Include <kern/fpa_counters.h>, for fpa_counters_t.
 * 	[89/01/01  15:03:52  rpd]
 * 
 * Revision 2.7  88/09/25  22:15:28  rpd
 * 	Changed sys/callout.h to kern/callout_statistics.h.
 * 	[88/09/09  14:00:19  rpd]
 * 	
 * 	Changed includes to the new style.
 * 	Added include of sys/callout.h.
 * 	[88/09/09  04:47:42  rpd]
 * 
 * Revision 2.6  88/08/06  18:22:34  rpd
 * Changed sys/mach_ipc_netport.h to kern/ipc_netport.h.
 * 
 * Revision 2.5  88/07/21  00:36:06  rpd
 * Added include of ipc_statistics.h.
 * 
 * Revision 2.4  88/07/17  19:33:20  mwyoung
 * *** empty log message ***
 * 
 * 29-Jun-88  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Use new <vm/memory_object.h>.
 *
 *  9-Apr-88  Daniel Julin (dpj) at Carnegie-Mellon University
 *	Changed mach_ipc_vmtp.h to mach_ipc_netport.h.
 *
 *  1-Mar-88  Mary Thompson (mrt) at Carnegie Mellon
 *	Added a conditional on _MACH_INIT_ before the include
 *	of mach_init.h so that the kernel make of mach_user_internal
 *	would not include mach_init.h
 *
 * 18-Jan-88  David Golub (dbg) at Carnegie-Mellon University
 *	Added includes of task_info, thread_info, task_special_ports,
 *	thread_special_ports for new interfaces.
 *
 * 12-Dec-87  Michael Young (mwyoung) at Carnegie-Mellon University
 *	Reduced old history.
 */

#ifndef	_MACH_TYPES_
#define	_MACH_TYPES_	1
#define	_MACH_IF_	1	/* old module name */

#include <sys/port.h>
#include <vm/vm_inherit.h>
#include <vm/vm_prot.h>
#include <vm/memory_object.h>
#include <vm/vm_statistics.h>
#include <machine/vm_types.h>
#include <sys/machine.h>
#include <sys/thread_status.h>
#include <sys/thread_info.h>
#include <sys/thread_special_ports.h>
#include <sys/task_info.h>
#include <sys/task_special_ports.h>
#include <kern/ipc_netport.h>

#ifdef	KERNEL
#include <sys/task.h>
#include <sys/thread.h>

#include <vm/vm_user.h>
#include <vm/vm_object.h>
#else	KERNEL
typedef	port_t		task_t;
typedef	task_t		vm_task_t;
typedef	port_t		thread_t;
typedef	thread_t	*thread_array_t;
#endif	KERNEL

typedef	vm_offset_t	vm_address_t;
typedef	unsigned int	vm_region_t;
typedef	vm_region_t	*vm_region_array_t;

typedef	char		vm_page_data_t[4096];

#ifdef	KERNEL
/*
 *	Conversion routines, to let Matchmaker do this for
 *	us automagically.
 */

extern task_t convert_port_to_task( /* port_t x */ );
extern thread_t convert_port_to_thread( /* port_t x */ );
extern vm_map_t convert_port_to_map( /* port_t x */ );
extern port_t convert_task_to_port( /* task_t x */ );
extern port_t convert_thread_to_port( /* thread_t x */ );

#if	_memory_object || _memory_object_default
#define	msg_send	msg_send_from_kernel
#endif	_memory_object || _memory_object_default

#else	KERNEL
/*
 *	Get things imported from the runtime environment startup.
 */
#ifndef	_MACH_INIT_
#include <mach_init.h>
#endif	_MACH_INIT_
#endif	KERNEL

#endif	_MACH_TYPES_
