/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	ipc_statistics.h,v $
 * Revision 2.3  89/01/15  16:32:13  rpd
 * 	Use decl_simple_lock_data.
 * 	[89/01/15  15:10:25  rpd]
 * 
 * Revision 2.2  89/01/12  07:59:55  rpd
 * 	Created.
 * 	[89/01/12  04:23:06  rpd]
 * 
 */ 

#ifndef	_IPC_STATISTICS_H_
#define	_IPC_STATISTICS_H_	1

#ifdef	KERNEL
#include <mach_ipc_stats.h>
#endif	KERNEL

/*
 *	Remember to update the mig type definition
 *	in mach_debug_types.defs when adding/removing fields.
 */

typedef struct {
	int		version;
	int		messages;
	int		complex;
	int		kernel;
	int		large;
	int		current;
	int		emergency;
	int		notifications;
	int		port_copyins;
	int		port_copyouts;
	int		port_copyin_hits;
	int		port_copyout_hits;
	int		port_allocations;
	int		bucket_misses;
	int		ip_data_grams;
} ipc_statistics_t;

#ifdef	KERNEL

#include <sys/lock.h>
#include <kern/macro_help.h>

decl_simple_lock_data(extern,ipc_statistics_lock_data)
extern ipc_statistics_t ipc_statistics;

extern void ipc_stats_init();

#define ipc_statistics_lock()	simple_lock(&ipc_statistics_lock_data)
#define ipc_statistics_unlock()	simple_unlock(&ipc_statistics_lock_data)

#if	MACH_IPC_STATS

#define ipc_event_count(field, count)		\
MACRO_BEGIN					\
	ipc_statistics_lock();			\
	ipc_statistics.field += count;		\
	ipc_statistics_unlock();		\
MACRO_END

#else	MACH_IPC_STATS
#define ipc_event_count(field, count)
#endif	MACH_IPC_STATS

#define ipc_event(field)		ipc_event_count(field, 1)

#endif	KERNEL
#endif	_IPC_STATISTICS_H_
