#!/bin/csh -f
set d=$cwd
set lib=$d/../lib/V
cd ${CIBASE}
echo "[ creating INDEX.new ]"
find -nosymlink . -newer $d/INDEX -name "*,v" -exec rlog {} \; \
| \
awk -f $lib/mkindex.awk >$d/INDEX.new
echo "[ merging INDEX and INDEX.new ]"
awk 'BEGIN {\
    FS = ";"; \
}\
FILENAME == "-" { \
    print $0; \
    new[$3] = $3; \
    next; \
} \
{ \
    if (new[$3] == "") \
	print $0; \
}' - $d/INDEX <$d/INDEX.new \
| \
sort -t\; +1r -2 >$d/INDEX.upd
if (! -z $d/INDEX.upd) then
    cmp -s $d/INDEX $d/INDEX.upd
    if ("$status" == 0) then
	echo "[ no changes to INDEX ]"
    else
	echo "[ updating INDEX ]"
	mv $d/INDEX $d/INDEX.old
	mv $d/INDEX.upd $d/INDEX
	diff $d/INDEX.old $d/INDEX | more
    endif
endif
rm -f $d/INDEX.new $d/INDEX.upd
