#!/bin/csh -f

set prog=$0
set prog=${prog:t}

set lib=../lib/V

while ($#argv > 0)
    if ("$argv[1]" !~ -*) break
    switch ("$argv[1]")
	case -part2:
	    set part2
	    breaksw
	default:
	    echo "${0}: unknown switch: $1"
	    exit 1
	    breaksw
    endsw
    shift
end

if (! $?part2) then
    if ($#argv != 1) then
	echo "Usage: ${0} <RCS-revision-of-edit>"
	exit 1
    endif

    echo $1 | awk -f $lib/rev.awk - INDEX | exec $0 -part2
endif

set tmp1=/tmp/${prog}a$$ tmp2=/tmp/${prog}b$$

while (1)
    set f="$<"
    set f=($f)
    if ($#f == 0) break
    if ($?begin) then
	if ($f[1] != $begin) continue
	unset begin
    endif
    echo "[ $f[1] ]"
    set rfile=$f[1]
    set rfile=${CIBASE}/${rfile:h}/RCS/${rfile:t},v
    rcsco -p$f[2] -q $rfile | sed -n '/HISTORY/,$p' | sed -n '1,/^$/p' >$tmp1
    if ($#f > 2) then
	rcsco -p$f[3] -q $rfile | sed -n '/HISTORY/,$p' | sed -n '1,/^$/p' >$tmp2
    else
	echo >$tmp2
    endif
    diff $tmp2 $tmp1
    rm -f $tmp2 $tmp1
end
