#!/bin/csh -f
#
# HISTORY
# $Log:	setacl.csh,v $
# Revision 2.2  88/08/30  00:06:51  mwyoung
# 	Created by someone else.  I got stuck checking it in.
# 
#
# completely resets the vice access to all the directories
# in /afs/cs/os/source/{latest,alpha...}/kernel
# to use cd to the kernel directory in question and setacls

set all_al="kernel:View read kernel:UpdateSource all system:UpdateSource all  $*"
set sqt_al='kernel:View.SEQUENT read'
set mmx_al='kernel:View.ENCORE read'
set dec_al='kernel:View.ULTRIX read'
set sun_al='kernel:View.SUN read'
set ibm_al='kernel:View.IBM read'
set bsd_al='kernel:View.4BSD read'
set cmu_al='kernel:View.Local read'

set table=(\
    cmu "compat inline kern lib man mdb src sup uxkern vm" \
    bsd "RCS bsd cassette conf consolerl dist floppy h mdec net netimp netinet netns stand src/config src/kdb sys vax vaxif vaxmba vaxuba" \
    dec "emul ultrix" \
    sun "mon pixrect sun sun3 sundev sunif sunkdb sunstand sunwindow sunwindowdev sysV" \
    ibm "standca ca cacons caif caio vice" \
    mmx "mmax mmaxif mmaxio" \
    sqt "sqt sqtconf sqtif sqtmbad sqtsec sqtzdc" \
)

fs sac . kernel:View.Local read kernel:View.Any l $all_al

foreach type ($table:q)
    if (! $?class) then
	set class="$type"
    else
	echo "[ $class ]"
	eval 'set al=($'${class}_al')'
	find $type -type d -print -exec fs sac {} $all_al $al \;
	unset class
    endif
end

