/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	8530.h,v $
 * Revision 2.2  88/08/06  18:27:49  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_8530_H
#define	_STANDCA_8530_H	1

/* $Header: 8530.h,v 2.2 88/08/06 18:27:49 rpd Exp $ */
/* $ACIS:8530.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/8530.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsid8530 = "$Header: 8530.h,v 2.2 88/08/06 18:27:49 rpd Exp $";
#endif

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* Support for the Zilog 8530                                         */

#define    Pri8530       0xF000202A    /* First 8530 addr. */
#define    Alt8530       0xF000002A    /* Second 8530 addr. */
#define    Shr8530       0xF000042A    /* Shared 8530 data */
#define    Rst8530       0xF000002D    /* Reset 8530 addr. */
#define    RstRS232      0xF000042D    /* Reset RS232 addr. */

#define    Chn8530A      0	       /* DMA channel for A */
#define    Chn8530B      1	       /* DMA channel for B */

#define    Dma8530B      0x80	       /* Enable DMA       */
#define    Irq8530B      0x20	       /* Interrupt ack.   */
#define    Dtr8530B      0x10	       /* Set DTR          */
#define    Dma8530A      0x08	       /* Enable DMA       */
#define    Irq8530A      0x02	       /* Interrupt Ack.   */
#define    Dtr8530A      0x01	       /* Set DTR          */

#define    RgI8530B      0x40	       /* Ring indicate    */
#define    Dsr8530B      0x20	       /* Data Set Ready   */
#define    Fbk8530B      0x10	       /* DTR feedback     */
#define    RgI8530A      0x04	       /* Ring indicate    */
#define    Dsr8530A      0x02	       /* Data Set Ready   */
#define    Fbk8530A      0x01	       /* DTR feedback     */

#endif	_STANDCA_8530_H
