/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	aedtty.c
 *
 * HISTORY
 * $Log:	aedtty.c,v $
 * Revision 2.2  88/08/06  18:31:32  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header: aedtty.c,v 2.2 88/08/06 18:31:32 rpd Exp $ */
/* $ACIS:aedtty.c 9.2$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/aedtty.c,v $ */

#ifndef lint
static char *rcsid = "$Header: aedtty.c,v 2.2 88/08/06 18:31:32 rpd Exp $";
#endif

#include "aed.h"
#if NAED > 0
#include "../machine/machparam.h"
#include "aedtty.h"
#include "../cacons/aed_tty_mcode.h"


aed_probe(rwaddr)
register char *rwaddr;
{
	short poll;


	/* read control store to reset AED (Must be done for sensing) */
	aedrd(&poll, 1, 0X0000);
	AED_DELAY;

	/* Now do the normal screen probe routine */
	return (screen_probe(rwaddr));
}

aed_screen_init()
{
#ifndef AED_SET
	register int len;
	unsigned short aedcmd[10];
	short poll;		       /* semaphore word */

	/* read control store to reset AED */
	aedrd(&poll, 1, 0X0000);
	AED_DELAY;

	/* copy microcode file into control store */
	aedwr(aed_tty_mcode, AEDTTY_MC_LEN / 2, 0x0000);
	AED_DELAY;

	/* send a null command to the AED to start and wait for ready */
	aedrd(&poll, 1, 0X0002);
	AED_DELAY;
	aed_tty_command(0, 0);

#endif AED_SET

	/* Initialize AED sram pointers */
	vinit();
	delay(5);
#ifndef BLACK_ON_WHITE
	vterm('\033');
	vterm('S');
#endif
}


aed_tty_command(buff, nwords)
	register char *buff;	       /* Buffer to give to AED */
	register short nwords;	       /* number of words to transfer */

{
	short poll;		       /* semaphore word */

	/* copy the AED buffer to shared ram */
	aedwr(buff, nwords, 0X4002);

	/* Wake up microcode */
	poll = 1;
	aedwr(&poll, 1, 0X4000);

	/* wait for completion */
	do {
		AED_DELAY;
		aedrd(&poll, 1, 0X4000);
	} while (poll != 0);

}


aed_screen_putc(c)
	register char c;
{
	vterm(c);
}


aed_put_status(pos,str)
	register int pos;
	register char *str;
{
	register int c;

	vterm('\033');		/* send out ESC */
	vterm('4');		/* 	     4  */
	vterm(pos+' ');		/* column position plus offset */

	do
		{
		c = *str++;
		vterm(c);
		}
	while (c);
}

/* print the aed screen */
static char dumpline[4] = {'\033', '8', 0, 0};
/* static */ char aedbuffer[128];

aed_screen_print(si, flag)
register /* SCREEN_INFO * */ si;
register int flag;
{
#define AED_LINES	52
#define AED_WIDTH	80	/* to get it started */
	register int l, i;
	register char *p;
	extern lpstatus;
	char *aedline();

	/* print out the aed screen buffer on the printer */

 	for (l = 0; l < AED_LINES; ++l) /* */
		{
		p = aedline(l);
		for (i = 0; i < AED_WIDTH; i++, p++) 
			{
			if (!*p) break;	/* quit at terminating null */
			if (lp_put(p[0])) 
				{
				hard_delay(250);
				goto done; /* quit if error */
				}
			}
		lp_put('\r');
		lp_put('\n');
		}
	lp_put('\f');		       /* skip to top of form */
done:
	put_status(33, "        ");
	lpstatus = -1;
}

char *aedline(line)
	register int line;
{
	char *s, c;
	dumpline[2] = ' ' + line;	/* blank plus line# offset */
	s = dumpline;
	while (c = *s++)
		vterm(c);		/* send dumpline request */
	vwait();			/* be sure dumpline is complete */
	aedrd(aedbuffer,AED_WIDTH/2,0X4100);
	 	/* for characters. Attribute array at 0x4180 */
	aedbuffer[AED_WIDTH] = '\0';	/* paranoia */
	return(aedbuffer);
}
#endif NAEDTTY
