/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	aedtty.h,v $
 * Revision 2.2  88/08/06  18:32:09  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_AEDTTY_H
#define	_STANDCA_AEDTTY_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: aedtty.h,v 2.2 88/08/06 18:32:09 rpd Exp $ */
/* $ACIS:aedtty.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/aedtty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidaed_tty = "$Header: aedtty.h,v 2.2 88/08/06 18:32:09 rpd Exp $";
#endif

#define AED_MMAP	0xf40a0000
#define AED_DELAY	DELAY(2)

#define aedrd(X,Y,Z) bcopy(AED_MMAP+Z, X, Y+Y)
#define aedwr(X,Y,Z) bcopy(X, (AED_MMAP+Z), Y+Y)


#define term_mode	0x0200
#define setup_mode	0x0300
#define data_port	0x4000
#define status_port	0x4002

char *aedbase = (char *)AED_MMAP;

short *aed_data;
short *aed_status;
extern int delay_count;

#define AEDTMO (delay_count*256)

#define vinit() aed_data = (short *)(aedbase + data_port);

#define vwait()	{register int tmo = AEDTMO;\
			while (*aed_data) {\
				if(tmo-- < 0) {\
					aed_screen_init();\
					tmo = AEDTMO;\
				}\
				AED_DELAY; \
			} }
#define vterm(c)	{ \
			vwait(); \
			AED_DELAY;\
			*aed_data = (term_mode | c); \
			AED_DELAY;}

#define vsetup(c)	{ while (*aed_data) AED_DELAY; \
			AED_DELAY;\
			*aed_data = (setup_mode | c); \
			AED_DELAY; }

#endif	_STANDCA_AEDTTY_H
