/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	apa8ctty.h,v $
 * Revision 2.2  88/08/06  18:35:53  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_APA8CTTY_H
#define	_STANDCA_APA8CTTY_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header: apa8ctty.h,v 2.2 88/08/06 18:35:53 rpd Exp $ */
/* $ACIS:apa8ctty.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/apa8ctty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidapaEtty = "$Header: apa8ctty.h,v 2.2 88/08/06 18:35:53 rpd Exp $";
#endif

#include "apa_structs.h"

/*
 * Control register (short)
 */
#define APA8C_FC 0xF0000150

/*
 * Data mask registers (2 each 8 bits)
 */
#define APA8C_DM 0xF0000152

/*
 * Color Plane Select register.
 */
#define CPS_REG 0xF0000154

/*
 * Foreground/ Background register.
 */
#define FGBG_REG 0xF0000156

/*
 * Video Look-up Table register.
 */
#define VLT_REG 0xF0000158

/*
 * Display memory for the APA-8C
 */
#define APA8CBASE 0xF4D20000


/* bits 0-2  rotate count */
#define DCR_ROTMASK 0x0007

/* bits 3-5  logic unit function control */
#define DCR_FCMASK	0x0038
#define DCR_FCOR	0x0028
#define DCR_FCNOR	0x0038
#define DCR_FCPA	0x0010
#define DCR_FCPB	0x0000
#define DCR_FCPNA	0x0030
#define DCR_FCPNB	0x0020

#ifdef BLACK_ON_WHITE
#define DEFAULT_FUNC	DCR_FCPNB
#else
#define DEFAULT_FUNC	DCR_FCPB
#endif
#define HIDDEN_FUNC     DCR_FCPA
#define RDWR_FUNC	DCR_FCPA

/* 6-7 reserved */

/* 8-9 memory mode */
#define DCR_MEMMODE	0x0300
#define DCR_SWR		0x0000
#define DCR_ISWR	0x0100
#define DCR_ADWR	0x0200
#define DCR_AURW	0x0300

/* 10 inc/dec of the address counter */
#define DCR_DEC		0x0400
#define DCR_INC		~0x0400

/* 11 x/y stepping */
#define DCR_X		0x0800
#define DCR_Y		~0x0800

/* 12  1 means block transfer */
#define DCR_BT		0x1000

/* 13  1 means interrupt enable */
#define DCR_IEN		0x2000

/* 14  1 means Sync enable */
#define DCR_SEN		0x4000

/* 15  1 means Video enable */
#define DCR_VEN		0x8000

/* Data Mask Register masks (typically are the inverse of each other) */
#define DM_A		0xff00
#define DM_B		0x00ff

#define CLEAR_DM	0x0000
#define DEFAULT_DM	DM_B
#define HIDDEN_DM       DM_A
#define RDWR_DM		DM_A

/*
 * values for the writemask.
 */
#define NOMASK 0x0000
#define MASKBYTE2 0x00ff
#define MASKBYTE1 0xff00

/*
 * Values for the color plane select register.
 */
#define DEFAULT_CPS 0x001F;
#define MOVE_CPS    0x000F;

/*
 * Values for the foreground/background register.
 */
#define DEFAULT_FGBG 0x00F0;

/*
 * NOTE: A SCREEN is the visible area of the display.
 *	 A BITMAP is the whole display.
 *	 A HIDDEN is the hidden area of the display.
 */

/* Screen dimensions in pixels */

/*
 * screen width.
 */
#define SCREEN_WD	720
#define HIDDEN_WD	304
#define BITMAP_WD	(HIDDEN_WD + SCREEN_WD)

/*
 * screen height.
 */
#define SCREEN_HT	512

/*
 * Defines to work with the Video Look-up table.
 */
#define VLT_SIZE 16
#define FG_COLOR 0x3F00
#define BG_COLOR 0x0000

/*
 * Screen dimensions in bytes. Return BITMAP offsets.
 *
 * BITMAP_BYTE_WD is BITMAP_WD divided by 8 to get the number of bytes in 
 * a scan line.
 */

/*
 * screen width in bytes.
 */
#define SCREEN_BYTE_WD	90
#define HIDDEN_BYTE_WD	38
#define BITMAP_BYTE_WD	(HIDDEN_BYTE_WD + SCREEN_BYTE_WD)

/*
 * screen width in words
 */
#define SCREEN_WORD_WD DIV_BPW(SCREEN_WD)
#define HIDDEN_WORD_WD DIV_BPW(HIDDEN_WD)
#define BITMAP_WORD_WD DIV_BPW(BITMAP_WD)

#define TOP_SCANLINE 0

/*
 * The increment to the next scanline directly below the current scanline.
 */
#define NEXT_SL		(BITMAP_BYTE_WD)

/*
 * Bitmap to BUS address offsets.  All address offsets in the bitmap area
 * must be multiplied by 2 before being used as BUS offsets.
 */
#define BM_TO_BUS(n)	((n) << 1)

/*
 * Converts a bus address (0xf4d20000 - 0xf4d3ff00) to the scan line
 * number. (0 - 511)
 */
#define BUS_TO_SL(bus) (((int)bus & 0x1ff00) >> 8)
#define SL_TO_BUS(sl)  ((sl) << 8)

/*
 * Convert a logical line number to physical scan lines in the bitmap.
 */
#define LINE_TO_SL(line)	(((line) * col_ht) + TOP_SCANLINE)

/*
 * Convert a physical scan line to a logical line number.
 */
#define SL_TO_LINE(sl)	((sl - TOP_SCANLINE)/col_ht)

/*
 * The next macro takes a line number (0 - 31) and returns the BUS 
 * address for that line.
 */
#define LINE_TO_BUS(line) (line_addr[line])

/*
 * Now set up logical columns...
 */
#define FIRSTCOL 0
#define FIRSTLINE 0

/*
 * Convert logical columns to actual bytes in a scanline.
 */
#define COL_TO_BM(col) (DIV_BPB((col)*col_wd))

/*
 * Converts columns to BUS bytes without the BASE.
 */
#define COL_TO_BUS(col) (col_addr[col])

/*
 * Converts column to the rotate amount.
 */
#define COL_TO_ROTATE(col) ((8 - (col)) & DCR_ROTMASK)

/*
 * The physical bitmap addresses on the apa8C adaptor card
 * go from 0000 to 0xffff. (the size of a short or word, 16 bits addresses
 * these spots.
 */
#define MAXOFFSET 0xffff

/*
 * This is defined to be the last scan line in the hidden area.
 * It is needed because the side affect of setting the writemask registers
 * is the mask is also written to the bitmap.
 */
#define WRMASK_APA8CBASE (*(unsigned short *)(APA8CBASE+BM_TO_BUS(MAXOFFSET-1)))

#define SET_APA8C_FC(control_info)	{				\
	*(unsigned short *) APA8C_FC = (unsigned short)(control_info);	\
}

#define SET_APA8C_WRITEMASK(mask) {					\
	SET_APA8C_FC(DCR_SEN | DCR_VEN | DCR_ISWR | DCR_X | DCR_FCOR);	\
	WRMASK_APA8CBASE = (unsigned short) mask;			\
}

#define SET_APA8C_DATAMASK(mask) {					\
	*(unsigned short *)APA8C_DM = (unsigned short) mask;		\
}

#define FALSE 0
#define TRUE  1

/* 
 * Macros to indicate the type of function being performed. 
 */
#define IS_OR(func)	(func & 0x0008)
#define IS_A(func)	((func & 0x0010) && !(IS_OR(func))) 
#define IS_B(func)	(!(func & 0x0010) && !(IS_OR(func)))

/*
 * create a macro that does a "not" on the function control call.  By "not"
 * I mean turn a pass through A or B into a not pass through A or B
 * and turn an A or B into a not (A or B)
 */
#define NOTFC(N)  (IS_OR(N) ? ((N) ^ 0x0010) : ((N) ^ 0x0020))

#define IS_NOT_FUNC(N) ((N & 0x0020) && ((N & DCR_FCMASK) != DCR_FCOR))



#endif	_STANDCA_APA8CTTY_H
