/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	apa_structs.h,v $
 * Revision 2.2  88/08/06  18:38:57  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_APA_STRUCTS_H
#define	_STANDCA_APA_STRUCTS_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: apa_structs.h,v 2.2 88/08/06 18:38:57 rpd Exp $ */
/* $ACIS:apa_structs.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/apa_structs.h,v $ */

#ifndef lint
static char *rcsidapa_structs = "$Header: apa_structs.h,v 2.2 88/08/06 18:38:57 rpd Exp $";
#endif

/*
 * These typedef's and defines are used by both the APA-16 and the APA-8.
 */
#ifdef DEBUG
#define DEBUGF(cond,stat)	{ if (cond) { stat; } }
#else
#define DEBUGF(cond,stat)
#endif

/*
 * Header for the font information.  NOTE: This is the current (2/1/86) vfont
 * header struct.
 */
struct header {
	short magic;
	unsigned short size;
	short maxx;
	short maxy;
	short xtend;
}; 

/*
 * For each character there is dispatch information which tells where the
 * character is in the bitmap and how big it is.
 */
struct dispatch {
	unsigned short addr;
	short nbytes;
	char up,down,left,right;
	short width;
};

/*
 * Rectangles are useful for determining the area changed.
 */
typedef struct { 
	short origin_y;
	short origin_x;
	short corner_y;
	short corner_x;
} Blt_Rectangle;
 
typedef struct Blt_Bitmap {
	unsigned short *base;   /* pointer to the actual bits */
	Blt_Rectangle rect;     /* bounding rectangle */
	short nshorts;          /* number of shorts wide the bitmap is */
} Blt_Bitmap;

/*
 * The structure passed to the fontblt routine.
 */
typedef struct {
	Blt_Bitmap	src_bitmap;
	Blt_Rectangle	src_rect;
	Blt_Bitmap	dst_bitmap;
	Blt_Rectangle	dst_rect;
} fontbltstruct;

/* STRUCTURES */

/*
 * Font information.
 */
#define SIZEOF_DPLIST 256
struct font_head {
	struct header header; /* pointer to the header that describes
				  the font */
	struct dispatch dplist[SIZEOF_DPLIST]; /* An array of dispatch.
						Each dispatch tells where in 
						the table the character is 
						located. */
};

#define SETRECT(dst,l,t,r,b)					\
	{							\
		(dst)->origin_x = l;  (dst)->origin_y = t;	\
		(dst)->corner_x = r; (dst)->corner_y = b;	\
	}

#define FALSE 0
#define TRUE  1

#ifndef BPW
/*
 * Bits Per Word.
 */
#define BPW     16
#define LOG2_BPW        4
#define MOD_BPW(value)  ((value) & (BPW-1))
#define DIV_BPW(value)  (((unsigned short)(value)) >> LOG2_BPW)
#define MUL_BPW(value)  ((value) << LOG2_BPW)
 
/*
 * Bits TO Words.
 */
#define BTOW(bits)      (DIV_BPW((bits) + (BPW-1)))

/*
 * Macros for the division and multiplication by 2.
 */
#define DIV_2(n) ((n) >> 1)
#define MUL_2(n) ((n) << 1)
#define MOD_2(n) ((n) & 0x1)
#endif

#ifndef BPB
/*
 * Bits Per Byte.
 */
#define BPB             8
#define LOG2_BPB        3
#define MOD_BPB(value)  ((value) & (BPB-1))
#define DIV_BPB(value)  ((value) >> LOG2_BPB)
#define MUL_BPB(value)  ((value) << LOG2_BPB)
/*
 * Bits TO Bytes.
 */
#define BTOB(bits)      (DIV_BPB((bits) + (BPB-1)))
#endif


#endif	_STANDCA_APA_STRUCTS_H
