/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	asm.h,v $
 * Revision 2.2  88/08/06  18:41:05  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_ASM_H
#define	_STANDCA_ASM_H	1

/* $Header: asm.h,v 2.2 88/08/06 18:41:05 rpd Exp $ */
/* $ACIS:asm.h 9.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/asm.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidasm = "$Header: asm.h,v 2.2 88/08/06 18:41:05 rpd Exp $";
#endif

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: asm.h,v 2.2 88/08/06 18:41:05 rpd Exp $ */
/* $ACIS:asm.h 9.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/asm.h,v $ */


#ifndef GPROF
#define eye_profil(name) .globl _/**/name; .globl _.name; .align 2; _/**/name: .long _.name; .ascii "<name>"; .align 2; _.name
#else GPROF
#define eye_profile(name) .globl _/**/name; .globl _.name; \
 .align 2; _/**/name: .long _.name;\
                   .long #mcount;\
                   .ascii "<name>";\
                   .align 2;\
             _.name:\
                   st r14,-4(r1); mr r14,r0; bali r0,mcount; l r14,-4(r1); 9
#endif GPROF

/* call a C procedure called "name" */
#define CCALL(name,nargs) get r0,$_/**/name; /*get dp*/ \
	bali	r15,_.name;	/* call procedure */

#define eye_catcher(name) .ascii "<name>";.align 2; name


 #
 #  System Register equates:
 #
#define scr_ctrsrc	 r6		/* system control reg: counter src */
#define scr_ctr		 r7		/* counter */
#define scr_ts		 r8		/* timer status */
#define scr_ecr		 r9		/* exception control register */
#define scr_mq		 r10		/* multiplier/quotient */
#define scr_mcspcs	 r11		/* machine check/program check stat. */
#define scr_irb		 r12		/* interrupt request buffer */
#define scr_iar		 r13		/* instruction address register */
#define scr_ics		 r14		/* interrupt control status */
#define scr_cs		 r15		/* condition status */

 #  byte offsets into the 16 byte old/new ps pairs kept by CPU at 0x100

#define old_iar     0                   /* offset for old-iar field */
#define old_ics_cs  4                   /* offset for old ics + cs field */
#define new_iar     8                   /* offset for new iar field */
#define new_ics     12                  /* offset for new ics field */
#define svc_code    14                  /* offset for svc code field (svc only) */

#define RETREG r2

         .globl .oVncs
         .set .oVncs , 0

#endif	_STANDCA_ASM_H
