/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	boot.c
 *
 * HISTORY
 * $Log:	boot.c,v $
 * Revision 2.2  88/08/06  18:42:56  rpd
 * Added copyright & log.
 * 
 */

#include "../h/param.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/vm.h"
#include <a.out.h>
#include "saio.h"
#include "../h/reboot.h"

/*
 * Boot program... arguments passed in r10 and r11 determine
 * whether boot stops to ask for system name and which device
 * boot comes from.
 */

/* Types in r10 specifying major device */
char devname[][2] = {
	'h', 'd',		       /* 0 = hd */
	'd', 'k',		       /* 1 = dk */
	'u', 'd',		       /* 2 = ud */
	'f', 'd',		       /* 3 = fd */
};
#define POST_START	0x800	       /* POST address */
#define POST_END	0x1000	       /* next location after the POST */

char line[100] = "hd(0,0)vmunix.mach";
char defline[100] = "hd(0,0)vmunix.mach";

int retry = 0;
int getchar_timeout = 3000000;	       /* to get an auto cr */
char getchar_char = '\r';	       /* return a CR */
#define BASEMASK 0x0fff0000	       /* mask for calculating base address */

#undef main			       /* don't need debugger */
main()
{
	register howto, devtype;       /* howto=r11, devtype=r10 */
	int io;

#ifdef lint
	howto = 0;
	devtype = 0;
#endif
	printf("\nMach/4.3 Standalone Boot Program\n\n");
	printf("Default: %s (just press Enter or wait ~30 seconds)\n\n", defline);
	putchar(07);		       /* ring my chimes */
#ifdef JUSTASK
	howto = RB_ASKNAME | RB_SINGLE;
#else
	howto = RB_ASKNAME | RB_SINGLE;
#endif
	if ((howto & RB_ASKNAME) == 0) {
		if (devtype >= 0 && devtype < sizeof(devname) / 2
		    &&devname[devtype][0]) {
			defline[0] = line[0] = devname[devtype][0];
			defline[0] = line[1] = devname[devtype][1];
		} else
			howto = RB_SINGLE | RB_ASKNAME;
	}
	for (;;) {
		if (howto & RB_ASKNAME) {
			printf(": ");
			gets(line);
		} else
			printf(": %s\n", line);
		if (line[0] == 0) {
			howto = 0;     /* default: come up multiple */
			strcpy(line, defline);
			printf(": %s\n", line);
		}
		io = open(line, 0);
		if (io >= 0)
			copyunix(howto, io);
		if (++retry > 2)
			howto = RB_SINGLE | RB_ASKNAME;
	}
}


/*ARGSUSED*/
copyunix(howto, io)
	register howto, io;
{
	struct exec x;
	register int i;
	char *addr;
	register int baseaddr;	       /* segment base address */

	i = read(io, (char *) & x, sizeof x);
	if (i != sizeof x ||
	    (x.a_magic != 0407 && x.a_magic != 0413 && x.a_magic != 0410))
		_stop("Bad format\n");
	baseaddr = ((int)x.a_entry) & BASEMASK;	/* same base as entry */
/*
 * following allows boot to boot itself without overwritting itself (which
 * tends not to work very well).
 */
	if (baseaddr == (BASEMASK & (int)main)) {
		register int newbase = 0x10000;
		printf("would clobber boot - loading at %x rather than %x\n", newbase, baseaddr);
		baseaddr = newbase;    /* hope it's relocatable! */
		x.a_entry = (x.a_entry & ~BASEMASK) + baseaddr;
	}
	{
		register int size = x.a_text + x.a_data + x.a_bss;
		extern char end;

		if (baseaddr < (BASEMASK & (int)main) && baseaddr + size > ((BASEMASK & (int)main)))
			_stop("help: program overlaps boot!");
	}
	printf("%d", x.a_text);
	if (x.a_magic == 0413 && lseek(io, NBPG, 0) == -1)
		goto shread;
#ifdef SBMODEL
	/*
	 * protect the POST by splitting up any read the crosses the POST
	 * into three reads (refusing to read data into the POST.
	 */
	if (baseaddr <= POST_START && x.a_text > POST_END) {
		/* text will span the POST */
		register int len = POST_START - baseaddr;
		register char *p;
		char buff[POST_END - POST_START]; /* data for POST */

		if (read(io, (char *)baseaddr, len) != len)
			goto shread;   /* read up to POST */
		if (read(io, buff, POST_END - POST_START) != POST_END - POST_START)
			goto shread;   /* read POST */
		for (len = 0, p = buff; p < buff + POST_END - POST_START; ++p)
			if (*p)
				++len;
		if (len)
			printf("(%d non-zero POST)", len);
		else
			printf("*");   /* POST ok marker */
		len = x.a_text - (POST_END - baseaddr);
		if (read(io, (char *)POST_END, len) != len)
			goto shread;
	} else if (baseaddr + x.a_text < POST_END)
		printf("text/data inside POST\n");
	else			       /* fall thru to the normal case */
#endif	SBMODEL

	if (read(io, (char *)baseaddr, x.a_text) != x.a_text)
		goto shread;
	addr = (char *)x.a_text + baseaddr;
	if (x.a_magic == 0413 || x.a_magic == 0410)
		while ((int)addr & CLOFSET)
			*addr++ = 0;
	printf("+%d", x.a_data);
	if (read(io, addr, x.a_data) != x.a_data)
		goto shread;
	addr += x.a_data;
	printf("+%d", x.a_bss);
	x.a_bss += 128 * 512;	       /* slop */
	for (i = 0; i < x.a_bss; i++)
		*addr++ = 0;
	x.a_entry &= 0x0fffffff;       /* remove segment number */
	printf(" start 0x%x\n", x.a_entry);
	delay(100);		       /* give time to read it */
	if (*(short *)x.a_entry != 0)
		{
		close(io);
		(*((int(*)())x.a_entry))();
		}
	_stop("Entry instruction zero");
shread:
	_stop("Short read\n");
}
