/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	conf.c
 *
 * HISTORY
 * $Log:	conf.c,v $
 * Revision 2.2  88/08/06  18:46:40  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: conf.c,v 2.2 88/08/06 18:46:40 rpd Exp $ */
/* $ACIS:conf.c 9.1$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/conf.c,v $ */

#ifndef SQUEEEEZE
#ifndef lint
static char rcsid[] = "$Header: conf.c,v 2.2 88/08/06 18:46:40 rpd Exp $";
#endif
#endif


#include "param.h"
#include "inode.h"
#include "fs.h"

#include "saio.h"

int nullsys(), nullioctl();
int hdstrategy(), hdopen(), hdioctl();
int fdstrategy(), fdopen(), fdclose(), fdioctl(); /* floppy disk */

struct devsw devsw[] = {
	{ "fd", fdstrategy, fdopen, fdclose, fdioctl },	/* floppy disk */
	{ "hd", hdstrategy, hdopen, nullsys, hdioctl },
	{ 0, 0, 0, 0, 0 },
};

devread(io)
	register struct iob *io;
{
	int cc;

	io->i_flgs |= F_RDDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, READ);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}


devwrite(io)
	register struct iob *io;
{
	int cc;

	io->i_flgs |= F_WRDATA;
	io->i_error = 0;
	cc = (*devsw[io->i_ino.i_dev].dv_strategy)(io, WRITE);
	io->i_flgs &= ~F_TYPEMASK;
	return (cc);
}


devopen(io)
	register struct iob *io;
{
	int result;

	if ((result = (*devsw[io->i_ino.i_dev].dv_open)(io)) < 0)
		io->i_error = -result, result = -1;
	return(result);
}


devclose(io)
	register struct iob *io;
{

	(*devsw[io->i_ino.i_dev].dv_close)(io);
}


devioctl(io, cmd, arg)
	register struct iob *io;
	int cmd;
	caddr_t arg;
{

	return ((*devsw[io->i_ino.i_dev].dv_ioctl)(io, cmd, arg));
}


/*ARGSUSED*/
nullsys(io)
	struct iob *io;
{

	;
}


/*ARGSUSED*/
nullioctl(io, cmd, arg)
	struct iob *io;
	int cmd;
	caddr_t arg;
{

	return (ECMD);
}
