/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	conf.h,v $
 * Revision 2.2  88/08/06  18:47:18  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_CONF_H
#define	_STANDCA_CONF_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION  1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: conf.h,v 2.2 88/08/06 18:47:18 rpd Exp $ */
/* $ACIS:conf.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/conf.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidconf = "$Header: conf.h,v 2.2 88/08/06 18:47:18 rpd Exp $";
#endif

/*	conf.h	6.1	83/07/29	*/

/*
 * Declaration of block device
 * switch. Each entry (row) is
 * the only link between the
 * main unix code and the driver.
 * The initialization of the
 * device switches is in the
 * file conf.c.
 */
struct bdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	int	(*d_dump)();
	int	(*d_psize)();
	int	d_flags;
#ifdef STRUCT_FILL
	int	d_fill[2];	/* fill up to 8 words */
#endif
};

/*
 * Character device switch.
 */
struct cdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	int	(*d_stop)();
	int	(*d_reset)();
	struct tty *d_ttys;
	int	(*d_select)();
	int	(*d_mmap)();
#ifdef STRUCT_FILL
	int	d_fill[6];	/* fill up to 16 words */
#endif
};

/*
 * tty line control switch.
 */
struct linesw
{
	int	(*l_open)();
	int	(*l_close)();
	int	(*l_read)();
	int	(*l_write)();
	int	(*l_ioctl)();
	int	(*l_rint)();
	int	(*l_rend)();
	int	(*l_meta)();
	int	(*l_start)();
	int	(*l_modem)();
#ifdef STRUCT_FILL
	int	l_fill[6];	/* fill up to 16 words */
#endif
};

/*
 * Swap device information
 */
struct swdevt
{
	dev_t	sw_dev;
	int	sw_freed;
	int	sw_nblks;
#ifdef STRUCT_FILL
	int	sw_fill;	/* fill up to 4 words */
#endif STRUCT_FILL
};

#endif	_STANDCA_CONF_H
