/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	consio.h,v $
 * Revision 2.2  88/08/06  18:48:21  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_CONSIO_H
#define	_STANDCA_CONSIO_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: consio.h,v 2.2 88/08/06 18:48:21 rpd Exp $ */
/* $ACIS:consio.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/consio.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidconsio = "$Header: consio.h,v 2.2 88/08/06 18:48:21 rpd Exp $";
#endif

#define CONS_AED	0
#define CONS_APA16	1
#define CONS_APA8C      2
#define CONS_APA8	3
#define CONS_EGA        4
#define CONS_MONO	5
#define CONS_DUMMY	6	/* a dummy console */
#define CONS_EMGD	CONS_APA16
#define CONS_AMGD	CONS_APA8
#define CONS_AMGDC	CONS_APA8C

#define NUMBER_CONS	6	/* How many possible real consoles */

#define CONSDEV_PRESENT	0x01	/* screen is present */
#define CONSDEV_KERNEL	0x02	/* screen is available to the kernel */
#define CONSDEV_USER	0x04	/* screen is available to the user */
#define CONSDEV_INIT	0x08	/* screen has been inited for console output */
#define CONSDEV_OPEN	0x10	/* display hardware has been opened */

#define CONSDEV_ALIVE	(CONSDEV_PRESENT | CONSDEV_KERNEL) 
#define CONSDEV_USEIT	(CONSDEV_PRESENT | CONSDEV_USER) 
#define CONSDEV_BOTH	(CONSDEV_KERNEL | CONSDEV_USER)
#define	CONSDEV_NONE	0 		/* only the two bits will be used */

struct screen_control	{
	int device;		/* which screen device to control */
	int	switches;
};
	
/* ioctl numbers must fit into sequence in screen_conf.h */
#define SCRIOCGETF		_IOWR(c,9,struct screen_control)/* get screen flags */
#define SCRIOCSETC		_IOWR(c,10,struct screen_control)/* set screen config */

#define EOBUF	-1


#endif	_STANDCA_CONSIO_H
