/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	crcgen.c
 *
 * HISTORY
 * $Log:	crcgen.c,v $
 * Revision 2.2  88/08/06  18:48:54  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: crcgen.c,v 2.2 88/08/06 18:48:54 rpd Exp $ */
/* $ACIS:crcgen.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/crcgen.c,v $ */

#ifndef lint
static char *rcsid = "$Header: crcgen.c,v 2.2 88/08/06 18:48:54 rpd Exp $";
#endif

#define crc_mask 0xff07

/*==================================================================
 * function name - crc_gen
 * Purpose:	- This function generates a 2 byte, 16 bit, crc
 *	value from the suppliced parameter data that is returned
 *	to the calling code.
 * Inputs	- 2,
 *	first is an array of byte, char, data.
 *	second is the length of bytes of the array.
 *
 * Outputs	- 1
 *	a 16 bit crc value returned to caller
 ===================================================================*/


crc_gen(pbuff,length)
char pbuff[];
int length;
{
	union accum {
	short whole;
	struct bytes {
		char msb;
		char lsb;
		} byte;
	} avalue, dvalue;
	short ret_crc;
	char datav;
	int i;

	dvalue.whole = 0xffff;

/*==================================================================
 *
 * operate on each byte of data in the passed array, sending the 
 * data through the algorithm to generate a crc. Then use the crc
 * just generated as the base for the next pass of the data thru 
 * the algorithm.
 *==================================================================*/

	for (i=0; length>0; i++, length--) {
		datav = *(pbuff+i);
		avalue.byte.lsb = (datav ^ dvalue.byte.lsb);
		dvalue.byte.lsb = avalue.byte.lsb;
		avalue.whole = ((avalue.whole * 16) ^ dvalue.byte.lsb);
		dvalue.byte.lsb = avalue.byte.lsb;
		avalue.whole <<= 8;

		avalue.whole >>= 1;
		avalue.byte.lsb ^= dvalue.byte.lsb;

		avalue.whole >>= 4;
		avalue.whole = combine(avalue.byte.lsb,avalue.byte.msb);
		avalue.whole = ((avalue.whole & crc_mask) ^ dvalue.byte.lsb);
		avalue.whole = combine(avalue.byte.lsb,avalue.byte.msb);
		avalue.byte.lsb ^= dvalue.byte.msb;
		dvalue.whole = avalue.whole;
	}

	ret_crc = dvalue.whole;
	return(ret_crc);
}

combine(byte1,byte2)
char byte1, byte2;
{
	short ret_value;

	ret_value = ((byte1 << 8) | byte2);
	return(ret_value);
}
