/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	debug.h,v $
 * Revision 2.2  88/08/06  18:50:38  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_DEBUG_H
#define	_STANDCA_DEBUG_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: debug.h,v 2.2 88/08/06 18:50:38 rpd Exp $ */
/* $ACIS:debug.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/debug.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsiddebug = "$Header: debug.h,v 2.2 88/08/06 18:50:38 rpd Exp $";
#endif



int debug_option;			/* option flags */
#define OPTION_TRACE_TABLE 0x10		/* use trace table */
int debug_state;		       /* the current state of debug */
#define NORMAL_STATE	0	       /* we are just executing commands */
#define PCHECK_STATE	PC_VEC	       /* we've just had a program check */
#define MCHECK_STATE	MC_VEC	       /* we've just had a machine check */
#define STEP_STATE	INT0_VEC       /* we've just finished a step */
#define CALL_STATE	PROG_VEC       /* fake interrupt vector */
#define PM_STATE	PM_VEC		/* post mortem debugging */

#define REGSAVE 0x300		       /* put it somewhere safe */
#define GETREG(n) ((int *) regsave)[n]	/* pick up register value */

int *regsave;				/* pointer to saved registers */

/* note: currently the debug stack must be in low memory ( < 0x8000) */
#define DEBUG_STACK 0x2000	       /* used when in debugger from trap */
#define STM_R0	0xd900		       /* at stm r0, ... */
#define LM_R0	0xc900		       /* lm r0,... */
#define LPS	0xd000		       /* lps 0, ... */
#define CAL_R1	0xc810		       /* cal r1, ... */


#define INT0_VEC 0x100		       /* first interrupt vector */
#define MC_VEC 0x170		       /* machine check vector */
#define PC_VEC 0x180		       /* program check vector */
#define SVC_VEC	0x190		       /* svc vector */
#define PROG_VEC 0x1a0		       /* programmed entry */
#define PM_VEC	0x1b0			/* simulated vector for post mortem */

#define MAX_VEC	11		       /* number of interrupt vectors */

struct ivec {
	short *old_iar;
	short old_ics;
	short old_cs;
	short *new_iar;
	short new_ics;
	short new_fill;
};

struct svec {
	short *new_iar;
	short new_ics;
	short new_fill;
} save_vec[MAX_VEC];		       /* saved interrupt vectors */

#define SCR_ECR		9		/* Exception Control Register */
#define SCR_MQ		10		/* the Multiply Quotient register */
#define SCR_MCSPCS	11		/* MC and PC status register */
#define SCR_MCPC	11		/* MC and PC status register */
#define SCR_IRB		12		/* interrupt request register */
#define SCR_IAR		13		/* the IAR */
#define SCR_ICS		14		/* the ICS */
#define SCR_CS		15		/* the CS */

typedef int (*FN)();

int step_count;			       /* count for step instructions */

#define IRQ_0	0x8000		       /* IRQ 0 */
#define IRQ_1	0x4000		       /* IRQ 1 */
#define IRQ_2	0x2000		       /* IRQ 2 */
#define IRQ_3	0x1000		       /* IRQ 3 */
#define IRQ_4	0x0800		       /* IRQ 4 */
#define IRQ_5	0x0400		       /* IRQ 5 */
#define IRQ_6	0x0200		       /* IRQ 6 */
/*
 * following are simulated IRQ's as a way of telling init_vectors what
 * vectors to initialize.
 */
#define IRQ_MC	0x0100		       /* IRQ MC  */
#define IRQ_PC	0x0080		       /* IRQ PC  */
#define IRQ_SVC	0x0040		       /* IRQ SVC */
#define IRQ_PG	0x0020		       /* IRQ PROG if it existed */

#define ALL_IRQ	0xffff		       /* all vectors by bit flags */
#define DEBUG_IRQ IRQ_0 + IRQ_MC + IRQ_PC + IRQ_PG /* for debugger */

#define CODE_ADDR 0x280

#define USER_ICS	0x87	       /* don't stop, priority 7 */

#define TRACE_BIT	0x10	       /* T bit in LPS T,addr */

#include "../machine/mmu.h"

#define MAX_BREAK	16	       /* max number of break points */
#define BPT	0xbd11		       /* a break point (TGTE R1,R1) */

#define MAXSYMLEN 20

/*
 * NOTE: last symbol table entry must have a 'symbol[0] == 0'
 * in order to properly terminate the symbol table lookups.
 */
struct symtab {
	char symbol[MAXSYMLEN];	       /* the symbol */
	unsigned int value;	       /* it's value */
} *symtab;			       /* and a pointer to it */

#define ALLSYMS(s) s=symtab; s && s->symbol[0]; ++s

/* machine check status and program check status as in scr 11 */

#define MCS_RSC_CK     0x8000
#define MCS_PARITY_CK  0x2000
#define MCS_INS_TO     0x1000
#define MCS_DATA_TO    0x0800
#define MCS_RSC_TO     0x0400
#define MCS_IO_TRAP    0x0200

#define PCS_KNOWN      0x0080
#define PCS_UNKNOWN    0x0040
#define PCS_TRAP       0x0020
#define PCS_PRIV_I     0x0010
#define PCS_BAD_I      0x0008
#define PCS_IADDR      0x0004
#define PCS_DADDR      0x0002
#define PCS_RESERVED   0x0001

int err_flag;			       /* debugger error flag */
int iar_mask;			       /* mask for iar */

#define CSR_OHOH	0x04ffff00     /* bad bits to have on in CSR */
#define PROBLEM_ICS	0x0400	       /* problem state */
#define TRANS_ICS	0x0200	       /* translation mode */
#define NOINT_ICS	0x0100	       /* inhibit interrupts */

/*
 * the reason the order is so screwed up is the Volume 1 table is in
 * this order.
  */
#define CSR_PIOERR	0x01000000     /* 24 Programmed I/O error */
/*			0x02000000	/* 25 reserved */
#define CSR_SYSATTN	0x04000000     /* 26 system attention */
#define CSR_SOFTRESET	0x08000000     /* 27 soft reset */

#define CSR_EPOW	0x10000000     /* 28 power fail */
/*			0x20000000	/* 29 reserved */
#define CSR_INTPEND	0x40000000     /* 30 interrupt pending */
#define CSR_EXREP	0x80000000     /* 31 exception reported */

#define CSR_DMA8ERR	0x00010000     /* 16 DMA ERROR ch 8 */
#define CSR_DMA7ERR	0x00020000     /* 17 DMA ERROR ch 7 */
#define CSR_DMA6ERR	0x00040000     /* 18 DMA ERROR ch 6 */
#define CSR_DMA5ERR	0x00080000     /* 19 DMA ERROR ch 5 */

#define CSR_DMA3ERR	0x00100000     /* 20 DMA ERROR ch 3 */
#define CSR_DMA2ERR	0x00200000     /* 21 DMA ERROR ch 2 */
#define CSR_DMA1ERR	0x00400000     /* 22 DMA ERROR ch 1 */
#define CSR_DMA0ERR	0x00800000     /* 23 DMA ERROR ch 0 */

#define CSR_PIORP	0x00000100     /* 8 PIO Request Pending */
#define CSR_PBUSY	0x00000200     /* 9 Planar Busy */
#define CSR_CHRST	0x00000400     /* 10 Channel Reset */
#define CSR_DMAEX	0x00000800     /* 11 DMA Exception */

#define CSR_IOCHK	0x00001000     /* 12 I/O Channel Check */
#define CSR_INVOP	0x00002000     /* 13 Invalid Operation */
#define CSR_PROTECT	0x00004000     /* 14 Protection violation */
#define CSR_PIODMA	0x00008000     /* 15 PIO DMA */

#ifdef ROMPC
#include "../machine/ioim.h"
#endif ROMPC

#endif	_STANDCA_DEBUG_H
