/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	ega_font.h,v $
 * Revision 2.2  88/08/06  18:54:31  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_EGA_FONT_H
#define	_STANDCA_EGA_FONT_H	1

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: ega_font.h,v 2.2 88/08/06 18:54:31 rpd Exp $ */
/* $ACIS:ega_font.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/ega_font.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidega_font = "$Header: ega_font.h,v 2.2 88/08/06 18:54:31 rpd Exp $";
#endif

/*
 * Defines related to the ega font's
 */

#define FONT_ADDR	((char *)0xf40a0000)
#define FONT_SPACING	32
#define FONT_8x14_SIZE	16
#define FONT_8x8_SIZE	8

char ega_font8x14[] = {
	/*    Character ' ' (0x00) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x01) */
	0x00,0x00,0x7e,0x81,0xa5,0x81,0x81,0xbd,
	0x99,0x81,0x7e,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x02) */
	0x00,0x00,0x7e,0xff,0xdb,0xff,0xff,0xc3,
	0xe7,0xff,0x7e,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x03) */
	0x00,0x00,0x00,0x6c,0xfe,0xfe,0xfe,0xfe,
	0x7c,0x38,0x10,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x04) */
	0x00,0x00,0x00,0x10,0x38,0x7c,0xfe,0x7c,
	0x38,0x10,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x05) */
	0x00,0x00,0x18,0x3c,0x3c,0xe7,0xe7,0xe7,
	0x18,0x18,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x06) */
	0x00,0x00,0x18,0x3c,0x7e,0xff,0xff,0x7e,
	0x18,0x18,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x07) */
	0x00,0x00,0x00,0x00,0x00,0x18,0x3c,0x3c,
	0x18,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x08) */
	0xff,0xff,0xff,0xff,0xff,0xe7,0xc3,0xc3,
	0xe7,0xff,0xff,0xff,0xff,0xff,0x00, 0x00,
	/*    Character ' ' (0x09) */
	0x00,0x00,0x00,0x00,0x3c,0x66,0x42,0x42,
	0x66,0x3c,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x0a) */
	0xff,0xff,0xff,0xff,0xc3,0x99,0xbd,0xbd,
	0x99,0xc3,0xff,0xff,0xff,0xff,0x00, 0x00,
	/*    Character ' ' (0x0b) */
	0x00,0x00,0x1e,0x0e,0x1a,0x32,0x78,0xcc,
	0xcc,0xcc,0x78,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x0c) */
	0x00,0x00,0x3c,0x66,0x66,0x66,0x3c,0x18,
	0x7e,0x18,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x0d) */
	0x00,0x00,0x3f,0x33,0x3f,0x30,0x30,0x30,
	0x70,0xf0,0xe0,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x0e) */
	0x00,0x00,0x7f,0x63,0x7f,0x63,0x63,0x63,
	0x67,0xe7,0xe6,0xc0,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x0f) */
	0x00,0x00,0x18,0x18,0xdb,0x3c,0xe7,0x3c,
	0xdb,0x18,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x10) */
	0x00,0x00,0x80,0xc0,0xe0,0xf8,0xfe,0xf8,
	0xe0,0xc0,0x80,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x11) */
	0x00,0x00,0x02,0x06,0x0e,0x3e,0xfe,0x3e,
	0x0e,0x06,0x02,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x12) */
	0x00,0x00,0x18,0x3c,0x7e,0x18,0x18,0x18,
	0x7e,0x3c,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x13) */
	0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,
	0x00,0x66,0x66,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x14) */
	0x00,0x00,0x7f,0xdb,0xdb,0xdb,0x7b,0x1b,
	0x1b,0x1b,0x1b,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x15) */
	0x00,0x7c,0xc6,0x60,0x38,0x6c,0xc6,0xc6,
	0x6c,0x38,0x0c,0xc6,0x7c,0x00,0x00, 0x00,
	/*    Character ' ' (0x16) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xfe,0xfe,0xfe,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x17) */
	0x00,0x00,0x18,0x3c,0x7e,0x18,0x18,0x18,
	0x7e,0x3c,0x18,0x7e,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x18) */
	0x00,0x00,0x18,0x3c,0x7e,0x18,0x18,0x18,
	0x18,0x18,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x19) */
	0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,
	0x7e,0x3c,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x1a) */
	0x00,0x00,0x00,0x00,0x18,0x0c,0xfe,0x0c,
	0x18,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x1b) */
	0x00,0x00,0x00,0x00,0x30,0x60,0xfe,0x60,
	0x30,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x1c) */
	0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,0xc0,
	0xfe,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x1d) */
	0x00,0x00,0x00,0x00,0x28,0x6c,0xfe,0x6c,
	0x28,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x1e) */
	0x00,0x00,0x00,0x10,0x38,0x38,0x7c,0x7c,
	0xfe,0xfe,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x1f) */
	0x00,0x00,0x00,0xfe,0xfe,0x7c,0x7c,0x38,
	0x38,0x10,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x20) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '!' (0x21) */
	0x00,0x00,0x18,0x3c,0x3c,0x3c,0x18,0x18,
	0x00,0x18,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '"' (0x22) */
	0x00,0x66,0x66,0x66,0x24,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '#' (0x23) */
	0x00,0x00,0x6c,0x6c,0xfe,0x6c,0x6c,0x6c,
	0xfe,0x6c,0x6c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '$' (0x24) */
	0x18,0x18,0x7c,0xc6,0xc2,0xc0,0x7c,0x06,
	0x86,0xc6,0x7c,0x18,0x18,0x00,0x00, 0x00,
	/*    Character '%' (0x25) */
	0x00,0x00,0x00,0x00,0xc2,0xc6,0x0c,0x18,
	0x30,0x66,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '&' (0x26) */
	0x00,0x00,0x38,0x6c,0x6c,0x38,0x76,0xdc,
	0xcc,0xcc,0x76,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ''' (0x27) */
	0x00,0x30,0x30,0x30,0x60,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '(' (0x28) */
	0x00,0x00,0x0c,0x18,0x30,0x30,0x30,0x30,
	0x30,0x18,0x0c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ')' (0x29) */
	0x00,0x00,0x30,0x18,0x0c,0x0c,0x0c,0x0c,
	0x0c,0x18,0x30,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '*' (0x2a) */
	0x00,0x00,0x00,0x00,0x66,0x3c,0xff,0x3c,
	0x66,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '+' (0x2b) */
	0x00,0x00,0x00,0x00,0x18,0x18,0x7e,0x18,
	0x18,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ',' (0x2c) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x18,0x18,0x18,0x30,0x00,0x00,0x00, 0x00,
	/*    Character '-' (0x2d) */
	0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '.' (0x2e) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x18,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '/' (0x2f) */
	0x00,0x00,0x02,0x06,0x0c,0x18,0x30,0x60,
	0xc0,0x80,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '0' (0x30) */
	0x00,0x00,0x7c,0xc6,0xce,0xde,0xf6,0xe6,
	0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '1' (0x31) */
	0x00,0x00,0x18,0x38,0x78,0x18,0x18,0x18,
	0x18,0x18,0x7e,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '2' (0x32) */
	0x00,0x00,0x7c,0xc6,0x06,0x0c,0x18,0x30,
	0x60,0xc6,0xfe,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '3' (0x33) */
	0x00,0x00,0x7c,0xc6,0x06,0x06,0x3c,0x06,
	0x06,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '4' (0x34) */
	0x00,0x00,0x0c,0x1c,0x3c,0x6c,0xcc,0xfe,
	0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '5' (0x35) */
	0x00,0x00,0xfe,0xc0,0xc0,0xc0,0xfc,0x06,
	0x06,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '6' (0x36) */
	0x00,0x00,0x38,0x60,0xc0,0xc0,0xfc,0xc6,
	0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '7' (0x37) */
	0x00,0x00,0xfe,0xc6,0x06,0x0c,0x18,0x30,
	0x30,0x30,0x30,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '8' (0x38) */
	0x00,0x00,0x7c,0xc6,0xc6,0xc6,0x7c,0xc6,
	0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '9' (0x39) */
	0x00,0x00,0x7c,0xc6,0xc6,0xc6,0x7e,0x06,
	0x06,0x0c,0x78,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ':' (0x3a) */
	0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
	0x18,0x18,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ';' (0x3b) */
	0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
	0x18,0x18,0x30,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '<' (0x3c) */
	0x00,0x00,0x06,0x0c,0x18,0x30,0x60,0x30,
	0x18,0x0c,0x06,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '=' (0x3d) */
	0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,
	0x7e,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '>' (0x3e) */
	0x00,0x00,0x60,0x30,0x18,0x0c,0x06,0x0c,
	0x18,0x30,0x60,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '?' (0x3f) */
	0x00,0x00,0x7c,0xc6,0xc6,0x0c,0x18,0x18,
	0x00,0x18,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '@' (0x40) */
	0x00,0x00,0x7c,0xc6,0xc6,0xde,0xde,0xde,
	0xdc,0xc0,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'A' (0x41) */
	0x00,0x00,0x10,0x38,0x6c,0xc6,0xc6,0xfe,
	0xc6,0xc6,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'B' (0x42) */
	0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x66,
	0x66,0x66,0xfc,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'C' (0x43) */
	0x00,0x00,0x3c,0x66,0xc2,0xc0,0xc0,0xc0,
	0xc2,0x66,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'D' (0x44) */
	0x00,0x00,0xf8,0x6c,0x66,0x66,0x66,0x66,
	0x66,0x6c,0xf8,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'E' (0x45) */
	0x00,0x00,0xfe,0x66,0x62,0x68,0x78,0x68,
	0x62,0x66,0xfe,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'F' (0x46) */
	0x00,0x00,0xfe,0x66,0x62,0x68,0x78,0x68,
	0x60,0x60,0xf0,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'G' (0x47) */
	0x00,0x00,0x3c,0x66,0xc2,0xc0,0xc0,0xde,
	0xc6,0x66,0x3a,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'H' (0x48) */
	0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xfe,0xc6,
	0xc6,0xc6,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'I' (0x49) */
	0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,
	0x18,0x18,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'J' (0x4a) */
	0x00,0x00,0x1e,0x0c,0x0c,0x0c,0x0c,0x0c,
	0xcc,0xcc,0x78,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'K' (0x4b) */
	0x00,0x00,0xe6,0x66,0x6c,0x6c,0x78,0x6c,
	0x6c,0x66,0xe6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'L' (0x4c) */
	0x00,0x00,0xf0,0x60,0x60,0x60,0x60,0x60,
	0x62,0x66,0xfe,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'M' (0x4d) */
	0x00,0x00,0xc6,0xee,0xfe,0xfe,0xd6,0xc6,
	0xc6,0xc6,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'N' (0x4e) */
	0x00,0x00,0xc6,0xe6,0xf6,0xfe,0xde,0xce,
	0xc6,0xc6,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'O' (0x4f) */
	0x00,0x00,0x38,0x6c,0xc6,0xc6,0xc6,0xc6,
	0xc6,0x6c,0x38,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'P' (0x50) */
	0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x60,
	0x60,0x60,0xf0,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'Q' (0x51) */
	0x00,0x00,0x7c,0xc6,0xc6,0xc6,0xc6,0xd6,
	0xde,0x7c,0x0c,0x0e,0x00,0x00,0x00, 0x00,
	/*    Character 'R' (0x52) */
	0x00,0x00,0xfc,0x66,0x66,0x66,0x7c,0x6c,
	0x66,0x66,0xe6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'S' (0x53) */
	0x00,0x00,0x7c,0xc6,0xc6,0x60,0x38,0x0c,
	0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'T' (0x54) */
	0x00,0x00,0x7e,0x7e,0x5a,0x18,0x18,0x18,
	0x18,0x18,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'U' (0x55) */
	0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,
	0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'V' (0x56) */
	0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,
	0x6c,0x38,0x10,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'W' (0x57) */
	0x00,0x00,0xc6,0xc6,0xc6,0xc6,0xd6,0xd6,
	0xfe,0x7c,0x6c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'X' (0x58) */
	0x00,0x00,0xc6,0xc6,0x6c,0x38,0x38,0x38,
	0x6c,0xc6,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'Y' (0x59) */
	0x00,0x00,0x66,0x66,0x66,0x66,0x3c,0x18,
	0x18,0x18,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'Z' (0x5a) */
	0x00,0x00,0xfe,0xc6,0x8c,0x18,0x30,0x60,
	0xc2,0xc6,0xfe,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '[' (0x5b) */
	0x00,0x00,0x3c,0x30,0x30,0x30,0x30,0x30,
	0x30,0x30,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '\' (0x5c) */
	0x00,0x00,0x80,0xc0,0xe0,0x70,0x38,0x1c,
	0x0e,0x06,0x02,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ']' (0x5d) */
	0x00,0x00,0x3c,0x0c,0x0c,0x0c,0x0c,0x0c,
	0x0c,0x0c,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '^' (0x5e) */
	0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '_' (0x5f) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xff,0x00,0x00, 0x00,
	/*    Character '`' (0x60) */
	0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'a' (0x61) */
	0x00,0x00,0x00,0x00,0x00,0x78,0x0c,0x7c,
	0xcc,0xcc,0x76,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'b' (0x62) */
	0x00,0x00,0xe0,0x60,0x60,0x78,0x6c,0x66,
	0x66,0x66,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'c' (0x63) */
	0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xc0,
	0xc0,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'd' (0x64) */
	0x00,0x00,0x1c,0x0c,0x0c,0x3c,0x6c,0xcc,
	0xcc,0xcc,0x76,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'e' (0x65) */
	0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xfe,
	0xc0,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'f' (0x66) */
	0x00,0x00,0x38,0x6c,0x64,0x60,0xf0,0x60,
	0x60,0x60,0xf0,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'g' (0x67) */
	0x00,0x00,0x00,0x00,0x00,0x76,0xcc,0xcc,
	0xcc,0x7c,0x0c,0xcc,0x78,0x00,0x00, 0x00,
	/*    Character 'h' (0x68) */
	0x00,0x00,0xe0,0x60,0x60,0x6c,0x76,0x66,
	0x66,0x66,0xe6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'i' (0x69) */
	0x00,0x00,0x18,0x18,0x00,0x38,0x18,0x18,
	0x18,0x18,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'j' (0x6a) */
	0x00,0x00,0x06,0x06,0x00,0x0e,0x06,0x06,
	0x06,0x06,0x66,0x66,0x3c,0x00,0x00, 0x00,
	/*    Character 'k' (0x6b) */
	0x00,0x00,0xe0,0x60,0x60,0x66,0x6c,0x78,
	0x6c,0x66,0xe6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'l' (0x6c) */
	0x00,0x00,0x38,0x18,0x18,0x18,0x18,0x18,
	0x18,0x18,0x3c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'm' (0x6d) */
	0x00,0x00,0x00,0x00,0x00,0xec,0xfe,0xd6,
	0xd6,0xd6,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'n' (0x6e) */
	0x00,0x00,0x00,0x00,0x00,0xdc,0x66,0x66,
	0x66,0x66,0x66,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'o' (0x6f) */
	0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0xc6,
	0xc6,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'p' (0x70) */
	0x00,0x00,0x00,0x00,0x00,0xdc,0x66,0x66,
	0x66,0x7c,0x60,0x60,0xf0,0x00,0x00, 0x00,
	/*    Character 'q' (0x71) */
	0x00,0x00,0x00,0x00,0x00,0x76,0xcc,0xcc,
	0xcc,0x7c,0x0c,0x0c,0x1e,0x00,0x00, 0x00,
	/*    Character 'r' (0x72) */
	0x00,0x00,0x00,0x00,0x00,0xdc,0x76,0x66,
	0x60,0x60,0xf0,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 's' (0x73) */
	0x00,0x00,0x00,0x00,0x00,0x7c,0xc6,0x70,
	0x1c,0xc6,0x7c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 't' (0x74) */
	0x00,0x00,0x10,0x30,0x30,0xfc,0x30,0x30,
	0x30,0x36,0x1c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'u' (0x75) */
	0x00,0x00,0x00,0x00,0x00,0xcc,0xcc,0xcc,
	0xcc,0xcc,0x76,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'v' (0x76) */
	0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,
	0x66,0x3c,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'w' (0x77) */
	0x00,0x00,0x00,0x00,0x00,0xc6,0xc6,0xd6,
	0xd6,0xfe,0x6c,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'x' (0x78) */
	0x00,0x00,0x00,0x00,0x00,0xc6,0x6c,0x38,
	0x38,0x6c,0xc6,0x00,0x00,0x00,0x00, 0x00,
	/*    Character 'y' (0x79) */
	0x00,0x00,0x00,0x00,0x00,0xc6,0xc6,0xc6,
	0xc6,0x7e,0x06,0x0c,0xf8,0x00,0x00, 0x00,
	/*    Character 'z' (0x7a) */
	0x00,0x00,0x00,0x00,0x00,0xfe,0xcc,0x18,
	0x30,0x66,0xfe,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '{' (0x7b) */
	0x00,0x00,0x0e,0x18,0x18,0x18,0x70,0x18,
	0x18,0x18,0x0e,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '|' (0x7c) */
	0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,
	0x18,0x18,0x18,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '}' (0x7d) */
	0x00,0x00,0x70,0x18,0x18,0x18,0x0e,0x18,
	0x18,0x18,0x70,0x00,0x00,0x00,0x00, 0x00,
	/*    Character '~' (0x7e) */
	0x00,0x00,0x76,0xdc,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,
	/*    Character ' ' (0x7f) */
	0x00,0x00,0x00,0x00,0x10,0x38,0x6c,0xc6,
	0xc6,0xfe,0x00,0x00,0x00,0x00,0x00, 0x00,
	/* note: to save space only the essential fonts are used in
	 * standalone. (no characters 0x80-0xff)
	 */
};

char ega_font8x8[] = {
	/*    Character ' ' (0x00) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/*    Character ' ' (0x01) */
	0x7e,0x81,0xa5,0x81,0xbd,0x99,0x81,0x7e,
	/*    Character ' ' (0x02) */
	0x7e,0xff,0xdb,0xff,0xc3,0xe7,0xff,0x7e,
	/*    Character ' ' (0x03) */
	0x6c,0xfe,0xfe,0xfe,0x7c,0x38,0x10,0x00,
	/*    Character ' ' (0x04) */
	0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,
	/*    Character ' ' (0x05) */
	0x38,0x7c,0x38,0xfe,0xfe,0x7c,0x38,0x7c,
	/*    Character ' ' (0x06) */
	0x10,0x10,0x38,0x7c,0xfe,0x7c,0x38,0x7c,
	/*    Character ' ' (0x07) */
	0x00,0x00,0x18,0x3c,0x3c,0x18,0x00,0x00,
	/*    Character ' ' (0x08) */
	0xff,0xff,0xe7,0xc3,0xc3,0xe7,0xff,0xff,
	/*    Character ' ' (0x09) */
	0x00,0x3c,0x66,0x42,0x42,0x66,0x3c,0x00,
	/*    Character ' ' (0x0a) */
	0xff,0xc3,0x99,0xbd,0xbd,0x99,0xc3,0xff,
	/*    Character ' ' (0x0b) */
	0x0f,0x07,0x0f,0x7d,0xcc,0xcc,0xcc,0x78,
	/*    Character ' ' (0x0c) */
	0x3c,0x66,0x66,0x66,0x3c,0x18,0x7e,0x18,
	/*    Character ' ' (0x0d) */
	0x3f,0x33,0x3f,0x30,0x30,0x70,0xf0,0xe0,
	/*    Character ' ' (0x0e) */
	0x7f,0x63,0x7f,0x63,0x63,0x67,0xe6,0xc0,
	/*    Character ' ' (0x0f) */
	0x99,0x5a,0x3c,0xe7,0xe7,0x3c,0x5a,0x99,
	/*    Character ' ' (0x10) */
	0x80,0xe0,0xf8,0xfe,0xf8,0xe0,0x80,0x00,
	/*    Character ' ' (0x11) */
	0x02,0x0e,0x3e,0xfe,0x3e,0x0e,0x02,0x00,
	/*    Character ' ' (0x12) */
	0x18,0x3c,0x7e,0x18,0x18,0x7e,0x3c,0x18,
	/*    Character ' ' (0x13) */
	0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00,
	/*    Character ' ' (0x14) */
	0x7f,0xdb,0xdb,0x7b,0x1b,0x1b,0x1b,0x00,
	/*    Character ' ' (0x15) */
	0x3e,0x63,0x38,0x6c,0x6c,0x38,0xcc,0x78,
	/*    Character ' ' (0x16) */
	0x00,0x00,0x00,0x00,0x7e,0x7e,0x7e,0x00,
	/*    Character ' ' (0x17) */
	0x18,0x3c,0x7e,0x18,0x7e,0x3c,0x18,0xff,
	/*    Character ' ' (0x18) */
	0x18,0x3c,0x7e,0x18,0x18,0x18,0x18,0x00,
	/*    Character ' ' (0x19) */
	0x18,0x18,0x18,0x18,0x7e,0x3c,0x18,0x00,
	/*    Character ' ' (0x1a) */
	0x00,0x18,0x0c,0xfe,0x0c,0x18,0x00,0x00,
	/*    Character ' ' (0x1b) */
	0x00,0x30,0x60,0xfe,0x60,0x30,0x00,0x00,
	/*    Character ' ' (0x1c) */
	0x00,0x00,0xc0,0xc0,0xc0,0xfe,0x00,0x00,
	/*    Character ' ' (0x1d) */
	0x00,0x24,0x66,0xff,0x66,0x24,0x00,0x00,
	/*    Character ' ' (0x1e) */
	0x00,0x18,0x3c,0x7e,0xff,0xff,0x00,0x00,
	/*    Character ' ' (0x1f) */
	0x00,0xff,0xff,0x7e,0x3c,0x18,0x00,0x00,
	/*    Character ' ' (0x20) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	/*    Character '!' (0x21) */
	0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00,
	/*    Character '"' (0x22) */
	0x6c,0x6c,0x6c,0x00,0x00,0x00,0x00,0x00,
	/*    Character '#' (0x23) */
	0x6c,0x6c,0xfe,0x6c,0xfe,0x6c,0x6c,0x00,
	/*    Character '$' (0x24) */
	0x30,0x7c,0xc0,0x78,0x0c,0xf8,0x30,0x00,
	/*    Character '%' (0x25) */
	0x00,0xc6,0xcc,0x18,0x30,0x66,0xc6,0x00,
	/*    Character '&' (0x26) */
	0x38,0x6c,0x38,0x76,0xdc,0xcc,0x76,0x00,
	/*    Character ''' (0x27) */
	0x60,0x60,0xc0,0x00,0x00,0x00,0x00,0x00,
	/*    Character '(' (0x28) */
	0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00,
	/*    Character ')' (0x29) */
	0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00,
	/*    Character '*' (0x2a) */
	0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,
	/*    Character '+' (0x2b) */
	0x00,0x30,0x30,0xfc,0x30,0x30,0x00,0x00,
	/*    Character ',' (0x2c) */
	0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60,
	/*    Character '-' (0x2d) */
	0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,
	/*    Character '.' (0x2e) */
	0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00,
	/*    Character '/' (0x2f) */
	0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,0x00,
	/*    Character '0' (0x30) */
	0x7c,0xc6,0xce,0xde,0xf6,0xe6,0x7c,0x00,
	/*    Character '1' (0x31) */
	0x30,0x70,0x30,0x30,0x30,0x30,0xfc,0x00,
	/*    Character '2' (0x32) */
	0x78,0xcc,0x0c,0x38,0x60,0xcc,0xfc,0x00,
	/*    Character '3' (0x33) */
	0x78,0xcc,0x0c,0x38,0x0c,0xcc,0x78,0x00,
	/*    Character '4' (0x34) */
	0x1c,0x3c,0x6c,0xcc,0xfe,0x0c,0x1e,0x00,
	/*    Character '5' (0x35) */
	0xfc,0xc0,0xf8,0x0c,0x0c,0xcc,0x78,0x00,
	/*    Character '6' (0x36) */
	0x38,0x60,0xc0,0xf8,0xcc,0xcc,0x78,0x00,
	/*    Character '7' (0x37) */
	0xfc,0xcc,0x0c,0x18,0x30,0x30,0x30,0x00,
	/*    Character '8' (0x38) */
	0x78,0xcc,0xcc,0x78,0xcc,0xcc,0x78,0x00,
	/*    Character '9' (0x39) */
	0x78,0xcc,0xcc,0x7c,0x0c,0x18,0x70,0x00,
	/*    Character ':' (0x3a) */
	0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00,
	/*    Character ';' (0x3b) */
	0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x60,
	/*    Character '<' (0x3c) */
	0x18,0x30,0x60,0xc0,0x60,0x30,0x18,0x00,
	/*    Character '=' (0x3d) */
	0x00,0x00,0xfc,0x00,0x00,0xfc,0x00,0x00,
	/*    Character '>' (0x3e) */
	0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,
	/*    Character '?' (0x3f) */
	0x78,0xcc,0x0c,0x18,0x30,0x00,0x30,0x00,
	/*    Character '@' (0x40) */
	0x7c,0xc6,0xde,0xde,0xde,0xc0,0x78,0x00,
	/*    Character 'A' (0x41) */
	0x30,0x78,0xcc,0xcc,0xfc,0xcc,0xcc,0x00,
	/*    Character 'B' (0x42) */
	0xfc,0x66,0x66,0x7c,0x66,0x66,0xfc,0x00,
	/*    Character 'C' (0x43) */
	0x3c,0x66,0xc0,0xc0,0xc0,0x66,0x3c,0x00,
	/*    Character 'D' (0x44) */
	0xf8,0x6c,0x66,0x66,0x66,0x6c,0xf8,0x00,
	/*    Character 'E' (0x45) */
	0xfe,0x62,0x68,0x78,0x68,0x62,0xfe,0x00,
	/*    Character 'F' (0x46) */
	0xfe,0x62,0x68,0x78,0x68,0x60,0xf0,0x00,
	/*    Character 'G' (0x47) */
	0x3c,0x66,0xc0,0xc0,0xce,0x66,0x3e,0x00,
	/*    Character 'H' (0x48) */
	0xcc,0xcc,0xcc,0xfc,0xcc,0xcc,0xcc,0x00,
	/*    Character 'I' (0x49) */
	0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00,
	/*    Character 'J' (0x4a) */
	0x1e,0x0c,0x0c,0x0c,0xcc,0xcc,0x78,0x00,
	/*    Character 'K' (0x4b) */
	0xe6,0x66,0x6c,0x78,0x6c,0x66,0xe6,0x00,
	/*    Character 'L' (0x4c) */
	0xf0,0x60,0x60,0x60,0x62,0x66,0xfe,0x00,
	/*    Character 'M' (0x4d) */
	0xc6,0xee,0xfe,0xfe,0xd6,0xc6,0xc6,0x00,
	/*    Character 'N' (0x4e) */
	0xc6,0xe6,0xf6,0xde,0xce,0xc6,0xc6,0x00,
	/*    Character 'O' (0x4f) */
	0x38,0x6c,0xc6,0xc6,0xc6,0x6c,0x38,0x00,
	/*    Character 'P' (0x50) */
	0xfc,0x66,0x66,0x7c,0x60,0x60,0xf0,0x00,
	/*    Character 'Q' (0x51) */
	0x78,0xcc,0xcc,0xcc,0xdc,0x78,0x1c,0x00,
	/*    Character 'R' (0x52) */
	0xfc,0x66,0x66,0x7c,0x6c,0x66,0xe6,0x00,
	/*    Character 'S' (0x53) */
	0x78,0xcc,0xe0,0x70,0x1c,0xcc,0x78,0x00,
	/*    Character 'T' (0x54) */
	0xfc,0xb4,0x30,0x30,0x30,0x30,0x78,0x00,
	/*    Character 'U' (0x55) */
	0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xfc,0x00,
	/*    Character 'V' (0x56) */
	0xcc,0xcc,0xcc,0xcc,0xcc,0x78,0x30,0x00,
	/*    Character 'W' (0x57) */
	0xc6,0xc6,0xc6,0xd6,0xfe,0xee,0xc6,0x00,
	/*    Character 'X' (0x58) */
	0xc6,0xc6,0x6c,0x38,0x38,0x6c,0xc6,0x00,
	/*    Character 'Y' (0x59) */
	0xcc,0xcc,0xcc,0x78,0x30,0x30,0x78,0x00,
	/*    Character 'Z' (0x5a) */
	0xfe,0xc6,0x8c,0x18,0x32,0x66,0xfe,0x00,
	/*    Character '[' (0x5b) */
	0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00,
	/*    Character '\' (0x5c) */
	0xc0,0x60,0x30,0x18,0x0c,0x06,0x02,0x00,
	/*    Character ']' (0x5d) */
	0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00,
	/*    Character '^' (0x5e) */
	0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,
	/*    Character '_' (0x5f) */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
	/*    Character '`' (0x60) */
	0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00,
	/*    Character 'a' (0x61) */
	0x00,0x00,0x78,0x0c,0x7c,0xcc,0x76,0x00,
	/*    Character 'b' (0x62) */
	0xe0,0x60,0x60,0x7c,0x66,0x66,0xdc,0x00,
	/*    Character 'c' (0x63) */
	0x00,0x00,0x78,0xcc,0xc0,0xcc,0x78,0x00,
	/*    Character 'd' (0x64) */
	0x1c,0x0c,0x0c,0x7c,0xcc,0xcc,0x76,0x00,
	/*    Character 'e' (0x65) */
	0x00,0x00,0x78,0xcc,0xfc,0xc0,0x78,0x00,
	/*    Character 'f' (0x66) */
	0x38,0x6c,0x60,0xf0,0x60,0x60,0xf0,0x00,
	/*    Character 'g' (0x67) */
	0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0xf8,
	/*    Character 'h' (0x68) */
	0xe0,0x60,0x6c,0x76,0x66,0x66,0xe6,0x00,
	/*    Character 'i' (0x69) */
	0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00,
	/*    Character 'j' (0x6a) */
	0x0c,0x00,0x0c,0x0c,0x0c,0xcc,0xcc,0x78,
	/*    Character 'k' (0x6b) */
	0xe0,0x60,0x66,0x6c,0x78,0x6c,0xe6,0x00,
	/*    Character 'l' (0x6c) */
	0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00,
	/*    Character 'm' (0x6d) */
	0x00,0x00,0xcc,0xfe,0xfe,0xd6,0xc6,0x00,
	/*    Character 'n' (0x6e) */
	0x00,0x00,0xf8,0xcc,0xcc,0xcc,0xcc,0x00,
	/*    Character 'o' (0x6f) */
	0x00,0x00,0x78,0xcc,0xcc,0xcc,0x78,0x00,
	/*    Character 'p' (0x70) */
	0x00,0x00,0xdc,0x66,0x66,0x7c,0x60,0xf0,
	/*    Character 'q' (0x71) */
	0x00,0x00,0x76,0xcc,0xcc,0x7c,0x0c,0x1e,
	/*    Character 'r' (0x72) */
	0x00,0x00,0xdc,0x76,0x66,0x60,0xf0,0x00,
	/*    Character 's' (0x73) */
	0x00,0x00,0x7c,0xc0,0x78,0x0c,0xf8,0x00,
	/*    Character 't' (0x74) */
	0x10,0x30,0x7c,0x30,0x30,0x34,0x18,0x00,
	/*    Character 'u' (0x75) */
	0x00,0x00,0xcc,0xcc,0xcc,0xcc,0x76,0x00,
	/*    Character 'v' (0x76) */
	0x00,0x00,0xcc,0xcc,0xcc,0x78,0x30,0x00,
	/*    Character 'w' (0x77) */
	0x00,0x00,0xc6,0xd6,0xfe,0xfe,0x6c,0x00,
	/*    Character 'x' (0x78) */
	0x00,0x00,0xc6,0x6c,0x38,0x6c,0xc6,0x00,
	/*    Character 'y' (0x79) */
	0x00,0x00,0xcc,0xcc,0xcc,0x7c,0x0c,0xf8,
	/*    Character 'z' (0x7a) */
	0x00,0x00,0xfc,0x98,0x30,0x64,0xfc,0x00,
	/*    Character '{' (0x7b) */
	0x1c,0x30,0x30,0xe0,0x30,0x30,0x1c,0x00,
	/*    Character '|' (0x7c) */
	0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00,
	/*    Character '}' (0x7d) */
	0xe0,0x30,0x30,0x1c,0x30,0x30,0xe0,0x00,
	/*    Character '~' (0x7e) */
	0x76,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,
	/*    Character ' ' (0x7f) */
	0x00,0x10,0x38,0x6c,0xc6,0xc6,0xfe,0x00,
	/* note: to save space only the essential fonts are used in
	 * standalone. (no characters 0x80-0xff)
	 */
};


#endif	_STANDCA_EGA_FONT_H
