/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	gets.c
 *
 * HISTORY
 * $Log:	gets.c,v $
 * Revision 2.3  88/11/23  16:44:22  rpd
 * 	Added ^W from Acis.
 * 	[88/11/04  18:01:52  rpd]
 * 
 * Revision 2.2  88/08/06  18:57:51  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: gets.c,v 2.3 88/11/23 16:44:22 rpd Exp $ */
/* $ACIS:gets.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/gets.c,v $ */

#ifndef lint
static char *rcsid = "$Header: gets.c,v 2.3 88/11/23 16:44:22 rpd Exp $";
#endif

char *gets(buf)
	char *buf;
{
	register char *lp;
	register c;

	lp = buf;
	for (;;) {
		c = getchar() & 0177;
store:
		switch (c) {
		case '\n':
		case '\r':
			c = '\n';      /* treat both as newline */
			*lp++ = '\0';
			return(buf);
		case '\b':
			putchar(' ');
			putchar('\b');
		case '#':
			lp--;
			if (lp < buf)
				lp = buf;
			continue;
		case '@':
		case 'u' & 037:
			lp = buf;
			putchar('\n');
			continue;
		case '\04':		/* ^D - return nul byte */
			return((char *) 0);
		case '\03':		/* ^C - exit */
			exit(1);
			continue;	/* paranoia */
		case 'w' & 037:		/* ^W - wait for a second */
			delay(1000);
			continue;
		default:
			*lp++ = c;
		}
	}
}
