/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	hard_delay.c
 *
 * HISTORY
 * $Log:	hard_delay.c,v $
 * Revision 2.2  88/08/06  18:58:15  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: hard_delay.c,v 2.2 88/08/06 18:58:15 rpd Exp $ */
/* $ACIS:hard_delay.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/hard_delay.c,v $ */

#ifndef lint
static char *rcsid = "$Header: hard_delay.c,v 2.2 88/08/06 18:58:15 rpd Exp $";
#endif

#include "sa.h"
#define DELAY_COUNT 1000
#define DELAY_ADDRESS 0x80E0	       /* dummy write I/O hard_delay */
#ifdef ATR
#define DELAY_COUNT_ATR 1000
#endif ATR

int delay_count = DELAY_COUNT;

/*
 * delay for "n" milliseconds
 */
hard_delay(n)
	register int n;
{
	register int i;

#ifdef IBMRTPC
#ifdef ATR
	if (cpu != CPU_RTPC)
#endif ATR
		{
		while (--n >= 0)
			for(i=0;i<DELAY_COUNT;i++)
				OUT(DELAY_ADDRESS, 0xFF);
		return;
		}
#endif 

#ifdef ATR
	while (--n >= 0)
		for(i=0;i<DELAY_COUNT_ATR;i++);
#endif

}


delay(n)
	register int n;
{
 	hard_delay(n);
}

