/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	init.c
 *
 * HISTORY
 * $Log:	init.c,v $
 * Revision 2.3  88/11/23  16:45:02  rpd
 * 	Merged in 135 support from Acis.
 * 	[88/11/04  18:03:04  rpd]
 * 
 * Revision 2.2  88/08/06  19:00:33  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: init.c,v 2.3 88/11/23 16:45:02 rpd Exp $ */
/* $ACIS:init.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/init.c,v $ */

#ifndef lint
static char *rcsid = "$Header: init.c,v 2.3 88/11/23 16:45:02 rpd Exp $";
#endif


#include "../machine/cpu.h"

#ifdef ATR


#include "sa.h"
#include "../caio/hdconfig.h"    /* for diskinfo structure definition */

ushort *mem_size = (ushort *)0x00000800;
ushort *pcif_base = (ushort *)0x00000802;
long *cbcb_addr = (long *)0x00000804;
ushort *equip = (ushort *)0x00000808;
ushort *ega_info = (ushort *)0x0000080a;
long *pcxferbuf = (long *)0x0000080c;
long *pcclock    = (long *)0x00000810;
struct diskinfo *diskinfo = (struct diskinfo *) 0x00000814;
struct cbcb *cbcb;
char	delay_addr;



/*  
 * 	For the time being we will rely on the AT to set up 
 *	the display, keyboard, dma, and interrupt registers
 *      for us.
 */

#endif ATR


#ifdef IBMRTPC
#include "init.h"
#include "8530.h"

#define IOW_B(value,port) * (char *) (port) = value
#define IOW_H(value,port) * (short *) (port) = value
#define IOW_W(value,port) * (int *) (port) = value
#endif IBMRTPC

_init()
{
	register int p;
	static char regdata[16] = {
		0x61, 0x50, 0x52, 0x0F, 0x19, 0x06, 0x19, 0x19,
		0x02, 0x0D, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00
	};
	register int i;
	static clear_screen = 1;       /* if we must clear the screen */
#ifdef IBMRTPC
#ifdef ATR
	if (cpu == CPU_ATR)
		return;
#endif ATR
/* ***************************************************************** */
/* The purpose of this module is to initialize the hardware          */
/*                                                                   */
/* ***************************************************************** */

	IOW_B(0xff, CRRA);
	IOW_B(0xff, CRRB);

/* Initialize PC mono to make sure horizontal oscillator is running. */
	IOW_B(0x01, MonoCtl);	       /*  Set hi res bit.         */
	/*    enable bits,  cport 1 */
	for (i = 0; i <= 15; i += 1) { /*  Init 16  control regs   */
		IOW_B(i, MonoInx);     /*  Set cursor to up.left   */
		IOW_B(regdata[i], MonoData);
	}
	if (clear_screen) {
		clear_screen = 0;      /* only do it once */
		for (p = MonoBase; p < MonoBase + 4000; p += 4) {
			/*  Clear display to blanks */
			IOW_W((' ' << 24) + (' ' << 8) + 0x00070007, p);
		}
	}
	IOW_B(0x09, MonoCtl);	       /*  Set hi res bit, video   */
#ifdef ROMPC
#ifdef MOD135
	if (cpu_model == CPU_ROMPC || cpu_model == CPU_MOD135)
#else  MOD135
	if (cpu_model == CPU_ROMPC)
#endif MOD135
		init_ioims(cpu_model);	/* initialize the ioims */
#endif ROMPC
	{	/*
		 * Read disk adapter status registers to absorb
		 * interrupt(s) sometimes left outstanding by ROS.
		 */
		char junk = *(volatile char *)0xf00001f7 +
			    *(volatile char *)0xf0000177;
		junk = junk;
	}
#endif IBMRTPC
}

/*
 *  Functions for controlling the mapping of addresses from the ROMP
 *  address space to the PC address space.
 */

#ifdef ATR
int current_128_w;
int current_512_w;

/*
 *  PCIF registers 5 and 4 map the 512K and 128K windows respectively
 *  
 */

#define R5 5
#define R4 4

/*
 *  The 5 least significant bits of R5 are used with a 19 bit offset
 *  to produce a 24 bit physical address.
 */


/*
 *  The 7 least significant bits of R4 are used with a 17 bit offset
 *  to produce a 24 bit physical address.
 */


extern int pcif_io_b;
extern int pcif_io_hw;
#define PC_128_MASK	0x00fe0000	/* mask off hi and low order bits */
#define PC_512_MASK	0x00f80000	/* mask off hi and low order bits */

set_512_window(pc_addr)
{
	register int ioaddr = *pcif_base + R5 + pcif_io_hw;
	register int boundary,offset;

#ifdef IBMRTPC
	if (cpu != CPU_ATR)
		return(pc_addr);
#endif
	boundary = (pc_addr & PC_512_MASK) >> PCIF_R5_SHIFT;
	current_512_w = boundary;
	offset = (pc_addr & 0x0007FFFF);
	IOOUT(ioaddr, boundary); 
	return(offset);
}

set_128_window(pc_addr)
{
	register int ioaddr = *pcif_base + R4 + pcif_io_b;
	register int boundary,offset;

#ifdef IBMRTPC
	if (cpu != CPU_ATR)
		return(pc_addr);
#endif
	boundary = (pc_addr & PC_128_MASK) >> PCIF_R4_SHIFT;
	current_128_w = boundary;
	offset = (pc_addr & 0x0001FFFF);
	IOOUT(ioaddr,boundary);
	return(offset);
}

#endif ATR

#ifdef ROMPC
#include "../machine/ioim.h"
init_ioims(cpu_model)
int cpu_model;
{
	iow(IOIM1_BASE, (BUS1 << 8) + (IOIM1 >> 16));	/* initialize IOIM 1 */
	/* for now disable parity (chips don't work at 100ns) */
	iow(IOIM1+IOIM_GCR, ior(IOIM1+IOIM_GCR) | IOIM_NOPARITY);
#ifdef MOD135
	if (cpu_model != CPU_MOD135)
#endif MOD135
	iow(IOIM2_BASE, (BUS2 << 8) + (IOIM2 >> 16));	/* initialize IOIM 2 */
}
#endif ROMPC
