/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	init.h,v $
 * Revision 2.2  88/08/06  19:01:03  rpd
 * Created.
 * 
 */

#ifndef	_STANDCA_INIT_H
#define	_STANDCA_INIT_H	1

/* $Header: init.h,v 2.2 88/08/06 19:01:03 rpd Exp $ */
/* $ACIS:init.h 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/init.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidinit = "$Header: init.h,v 2.2 88/08/06 19:01:03 rpd Exp $";
#endif

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*    Jump, Low-jump hardware code dependencies.                     */
/*    All changes from Olympiad proto-model are noted in comments.   */
/*                                                                   */
/*    File:   IOADR INCJP --> init.h                                 */
/*    Last updated  09/27/84  (PL8->C W. Webb.)                      */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define    CDB        0xF0008CE0       /* Hex Display Register  */
/* #define CEAR       0xF0801008   remvd  * Chan. Error Adr Reg.  */
#define    Chn_Reset  0xF0801010       /* Channel reset address */
#define    Copsel     0xF0000042       /* CoProcessor skpr sel. */
#define    CSR        0xF0010800       /* Channel Status Reg.   */
#define    CSR_Reset  0xF0010810       /* Channel reset address */
/* #define CSR_Reset  0xF0801004   remvd  * CSR reset address     */
/* #define CSR_Read   'F0      'xb          * CSR rd cmd address    */
/* #define CSR_Write  'F0      'xb          * CSR wr cmd address    */
#define    CCR        0xF0008C20       /* Channel control reg   */
#define    CRRA       0xF0008C40       /* Component reset reg A */
#define    CRRB       0xF0008C60       /* Component reset reg B */
#define    Dbra       0xF00088C0       /* Dma buffer register   */
#define    Ddhalt     0x0C	       /* Diag DMA command      */
#define    Delay      0xF00080E0       /* Dummy write I/O delay */
#define    Diagmode   0xF0008C82       /* Diag DMA mode         */
#define    Diagexit   0xF0008C84       /* Diag DMA exit         */
#define    DiagDMA    0xF0008C80       /* Diag DMA              */
#define    Dmra       0xF00088E0       /* Dma mode   register   */
#define    Derb       0xF0008C00       /* Dma enable register   */
#define    Dma8Adr    0xF0008840       /* Dma8 Address root     */
#define    Dma8Cnt    0xF0008841       /* Dma8 Count root       */
#define    Dma8C0A    0xF0008840       /* Channel 0 address     */
#define    Dma8C0C    0xF0008841       /* Channel 0 count       */
#define    Dma8C1A    0xF0008842       /* Channel 1 address     */
#define    Dma8C1C    0xF0008843       /* Channel 1 count       */
#define    Dma8C2A    0xF0008844       /* Channel 2 address     */
#define    Dma8C2C    0xF0008845       /* Channel 2 count       */
#define    Dma8C3A    0xF0008846       /* Channel 3 address     */
#define    Dma8C3C    0xF0008847       /* Channel 3 count       */
#define    Dma8Sts    0xF0008848       /* Dma8 status           */
#define    Dma8Cmd    0xF0008848       /* Dma8 command          */
#define    Dma8Req    0xF0008849       /* Dma8 request          */
#define    Dma8Smk    0xF000884A       /* Dma8 single mask      */
#define    Dma8Mod    0xF000884B       /* Dma8 mode             */
#define    Dma8Ptr    0xF000884C       /* Dma8 reset pointer    */
#define    Dma8Tmp    0xF000884D       /* Dma8 temporary        */
#define    Dma8Rst    0xF000884D       /* Dma8 master reset     */
#define    Dma8Cmk    0xF000884E       /* Dma8 clear mask       */
#define    Dma8Amk    0xF000884F       /* Dma8 all mask         */
#define    Dma16Adr   0xF0008860       /* Dma16 Address root    */
#define    Dma16Cnt   0xF0008862       /* Dma16 Count root      */
#define    Dma16C5A   0xF0008864       /* Channel 5 address     */
#define    Dma16C5C   0xF0008866       /* Channel 5 count       */
#define    Dma16C6A   0xF0008868       /* Channel 6 address     */
#define    Dma16C6C   0xF000886A       /* Channel 6 count       */
#define    Dma16C7A   0xF000886C       /* Channel 7 address     */
#define    Dma16C7C   0xF000886E       /* Channel 7 count       */
#define    Dma16Sts   0xF0008870       /* Dma16 status          */
#define    Dma16Cmd   0xF0008870       /* Dma16 command         */
#define    Dma16Req   0xF0008872       /* Dma16 request         */
#define    Dma16Smk   0xF0008874       /* Dma16 single mask     */
#define    Dma16Mod   0xF0008876       /* Dma16 mode            */
#define    Dma16Ptr   0xF0008878       /* Dma16 reset pointer   */
#define    Dma16Tmp   0xF000887A       /* Dma16 temporary       */
#define    Dma16Rst   0xF000887A       /* Dma16 master reset    */
#define    Dma16Cmk   0xF000887C       /* Dma16 clear mask      */
#define    Dma16Amk   0xF000887E       /* Dma16 all mask        */
#define    ICW        0xF00088A0       /* Input register        */
#define    OCW        0xF00088A1       /* Output register       */
#define    KybCntlR   0xF0008406       /* 8255 control port read */
#define    KybCntlW   0xF0008407       /* 8255 control port wrt. */
#define    KybConfg   0xC3	       /* 8255 configuration    */
#define    KybRead    0xF0008404       /* 8255 data read        */
#define    KybWrite   0xF0008400       /* 8255 & command data   */
#define    MonoBase   0xF40B0000       /* PC1 monochrome display */
#define    MonoCtl    0xF00003B8       /* PC1 monochrome control */
#define    MonoInx    0xF00003B4       /* PC1 monochrome index  */
#define    MonoData   0xF00003B5       /* PC1 monochrome data   */
#define    PauseIOCC  0xF00080E0       /* Force 4 usec wait     */
#define    PrtrData   0xF00003BC       /* PC1 parallel prtr data */
#define    PrtrStat   0xF00003BD       /* PC1 parallel prtr stat */
#define    PrtrCtl    0xF00003BE       /* PC1 parallel prtr cntl */
#define    ResetKyb   0xF000082D       /* Reset 8255 and 8051   */
#define    Tcw        0xF0010000       /* Chngd Tcw base address      */
#define    TcwIncr    0x00000002       /* Chngd Tcw address increment */
#define    Todbas     0xF0008800       /* Time of day reg base  */
#define    Z8530SP    0xF0008000       /* 8530 Serial line      */

#endif	_STANDCA_INIT_H
