/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	lps.s
 *
 * HISTORY
 * $Log:	lps.s,v $
 * Revision 2.2  88/08/06  19:03:22  rpd
 * Created.
 * 
 */

/* $Header: lps.s,v 2.2 88/08/06 19:03:22 rpd Exp $ */
/* $ACIS:lps.s 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/lps.s,v $ */

	.data
rcsid:	.asciz	"$Header: lps.s,v 2.2 88/08/06 19:03:22 rpd Exp $"
	.text

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#include "asm.h"
 #
 # routine to do a lps to get off of program check or 
 # machine check level
 #
eye_profil(lps):
	bali	r3,1f		 # establish addressing
1:	.using	1b,r3
	st	r15,do_lps
	mfs	r14,r0		 # get current ics
	oi	r0,r0,0x180	 # make sure interrupts inhibited etc.
	sth	r0,do_lps+4	 # so that lps will restore it
	lps	0,do_lps

	.align	2
do_lps:
	.int	0
	.int	0x0180, 0x0000
