/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	parse.c
 *
 * HISTORY
 * $Log:	parse.c,v $
 * Revision 2.2  88/08/06  19:09:01  rpd
 * Created.
 * 
 */

/* $Header: parse.c,v 2.2 88/08/06 19:09:01 rpd Exp $ */
/* $ACIS:parse.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/parse.c,v $ */

#ifndef lint
static char *rcsid = "$Header: parse.c,v 2.2 88/08/06 19:09:01 rpd Exp $";
#endif

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#define	QUOTE1	'"'
#define QUOTE2	'\''
#define QUOTE3	'\\'
#define isspace(x) ((x) == ' ' || (x) == '\t')		/* ignore space and tab */

/*
 * argument parser: converts a ascii string into an argc/argv structure
 * given:
 *	parm	the ascii input string
 *	space	the place to store output strings (can be parm)
 *	argv	the place to put the string pointers
 *
 * the function value is the number of arguments found.
 * the following are processed correctly:
 * string string string
 * "string"
 * 'string'
 * string\ string
 * "string\"string"
 * The following is not processed properly:
 * string"string"
 */

int _parse(parm, space, argv)
	register char *parm, *space, **argv;
{
	register int argc = 0;	       /* number of args found */
	register int delim;

	while (isspace(*parm))
		++parm;
	for (; *parm; ++argc) {
		argv[argc] = space;
		/* collect this argument */
		while (*parm && !isspace(*parm)) {
			if (*parm == QUOTE1 || *parm == QUOTE2)
				delim = *parm++;
			else
				delim = ' ';
			while (*parm) {
				if (*parm == QUOTE3 && parm[1] == delim) {
					++parm;
					*space++ = *parm++;
				} else if (*parm == delim) {
					if (!isspace(delim))
						++parm;
					break;
				} else
					*space++ = *parm++;
			}
		}
		while (isspace(*parm))
			++parm;	       /* ignore trailing whitespace */
		*space++ = 0;	       /* end of argument */
	}
	argv[argc] = 0;		       /* make sure properly terminated */
	return (argc);		       /* argc is actual count */
}
