/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	premain.c
 *
 * HISTORY
 * $Log:	premain.c,v $
 * Revision 2.2  88/08/06  19:09:49  rpd
 * Created.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: premain.c,v 2.2 88/08/06 19:09:49 rpd Exp $ */
/* $ACIS:premain.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/premain.c,v $ */

#ifndef lint
static char *rcsid = "$Header: premain.c,v 2.2 88/08/06 19:09:49 rpd Exp $";
#endif


#undef main			       /* so we don't get hoisted on our own petard */

#define MAX_LINE	10240	       /* for Alex */
#define MAX_ARG		(MAX_LINE/4)

#include "debug.h"

int _prefirst;

main()
{
	extern char end;
	extern char edata;
	register char *p;
	char line[MAX_LINE];
	char *argv[MAX_ARG];
	register int argc;
	register int clear = 0;		/* startup did it first time */

	_init_vectors(0xffff);	       /* init all vectors */
	mtsr(SCR_ICS, USER_ICS);       /* allow interrupts, priority 7 */
	for (;;) {
/*
 * clear all of bss. This attempts to set conditions back to
 * an initial state. the putchar routine takes particular care to
 * keep all critial values in DATA rather than BSS space so that
 * the screen does not get erased by the following loop.
 */
		if (clear) {
			for (p = &edata; p < &end; ++p)
				*p = 0;
		}
		if (_prefirst++ == 0)
			printf("Enter arguments or debug (*) commands \n");
		printf("S/A %% ");
		gets(line);
		argc = _parse(line, line, argv);
		if (argc > 0 && *argv[0] == '*') {
			++argv[0];     /* skip past * */
			dump_cmd(argc, argv);
			clear = 0;
		} else {
			_main(argc, argv);
			printf("main program returned\n");
			clear = 1;
		}
	}
}
