/* 
 * Mach Operating System
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * File:	rdb.c
 *
 * HISTORY
 * $Log:	rdb.c,v $
 * Revision 2.2  88/08/06  19:10:49  rpd
 * Reverted to ACIS version.
 * 
 */

/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: rdb.c,v 2.2 88/08/06 19:10:49 rpd Exp $ */
/* $ACIS:rdb.c 9.0$ */
/* $Source: /afs/cs.cmu.edu/source_mach/rcs/kernel/standca/rdb.c,v $ */

#ifndef lint
static char *rcsid = "$Header: rdb.c,v 2.2 88/08/06 19:10:49 rpd Exp $";
#endif

#include "debug.h"
#include "cmds.h"		       /* the debugger commands */
#include <sys/reboot.h>
#include "../machine/rdb.h"
#include "../machine/cpu.h"

/*
 * interface to debugger that emulates RDB
 */

int getchar_timeout = 1000000;
char getchar_char = '\r';
int iar_mask;
char save_buffer[80 * 25 * 2];	       /* room for the screen */
char *screen_save = save_buffer;       /* the save buffer */

extern int lastdebugcmd;

startup(howto,devtype)
	register howto, devtype;       /* howto=r11, devtype=r10 */
{
	static init_flag = 0;
	static first_time = 0;
	extern char edata, end;
	register char *p;

	if (!init_flag) {
		for (p = &edata; p < &end; ++p)
			*p = 0;	       /* clear BSS */
/*	init_flag = 1;			/* reset the flag */
		_init();
		_init_vectors(DEBUG_IRQ); /* take just what's needed */
		mtsr(SCR_ICS, 0x81);   /* set up default ics */
		symtab = (struct symtab *) RDB_SYMTAB; /* set up symbol table pointer */
		iar_mask = 0x0fffffff; /* ignore segment number */
		lastdebugcmd = GO;     /* provide appropriate default */
		if (howto < 0 || howto > (RB_ASKNAME | RB_SINGLE | RB_NOSYNC | RB_HALT | RB_INITNAME))
			howto = RB_ASKNAME | RB_SINGLE;	/* better come up single ! */
	}
	for (;;) {
		if ((!first_time++) || howto) /* don't call debugger if first time */
			debugger();
		getchar_timeout = 0;	/* let's be paranoid */
		callabs(KERNEL_START,howto,devtype);	/* call the kernel */
	}
}
